/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** VESACORE.H: This file is part of the BETATRON library and can be used
 **             and/or distributed only under the terms of the GNU Library
 **             General Public License. See doc/readme.1st for details.
 */


#ifndef vesacore_h
#define vesacore_h

// arr einai enas pinakas
// pos einai i thesi mesa ston pinaka
// type einai o tipos tou pediou pou brisketai se auti ti thesi
// xrisimopoieitai stin ilopoiisi domis me pinaka

#define getfield( arr, pos, type)	 ( (type) ( *( (type *)((arr)+(pos)) )) )

// epeidi o djgpp me optimization allazei to padding ton pedion sta structures
// kai o wc ti seira tous den tha xrisimopoiisoume eggrafi


// thetei ti start address xrisimopoiontas to protected mode interface
// pou epistrefei i antistoixi vbe function

/* to asteraki meta tin call, diladi call *%2 einai
  gia absolute addressing (isodinamo me to antistoixo tou
  intel syntax, allios to call %2 isodinamei me to call
  ip+%2 (ip=instruction pointer)
*/

typedef unsigned short (*Tvbefunction)(void);
typedef Tvbefunction Tvbefunctions[3];

#define VBEINFOSIZE 		512
#define VBEMODEINFOSIZE 	256


/* enas pinakas trion deikton se functions
   [0]: set window call
   [1]: set display start
   [2]: set palette data
*/

char pl_getVBEinfo(char *info);
char pl_getVBEmodeinfo(char  *info, unsigned short mode);
char pl_setVBEmode(unsigned short mode);
unsigned short pl_setVBEscanlinelength(short lentgh);
char pl_getVBEprotectedcode(Tvbefunctions table, char * &code);
char pl_saverestoreVBEstate(unsigned char command, char * &buf, short &size);



// Tvbeinfoblock

#define  VBESignature					0
#define  VBEVersion 					4
#define  VBEOemStringPtr				6
#define  VBECapabilities				10
#define  VBEVideoModePtr				14
#define  VBETotalMemory 				18
#define  VBEOemSoftwareRev				20
#define  VBEOemVendorNamePtr			22
#define  VBEOemProductNamePtr			26
#define  VBEOemProductRevPtr			30
#define  VBEReserved0					34
#define  VBEOemData 					256


// Tmodeinfoblock

	 // Mandatory information for all VBE revisions
#define   VBEModeAttributes 	  0
#define   VBEWinAAttributes 	  2
#define   VBEWinBAttributes 	  3
#define   VBEWinGranularity 	  4
#define   VBEWinSize			  6
#define   VBEWinASegment		  8
#define   VBEWinBSegment		  10
#define   VBEWinFuncPtr 		  12
#define   VBEBytesPerScanLine	  16
	 // Mandatory information for VBE 1.2 and above
#define   VBEXResolution		  18
#define   VBEYResolution		  20
#define   VBEXCharSize			  22
#define   VBEYCharSize			  23
#define   VBENumberOfPlanes 	  24
#define   VBEBitsPerPixel		  25
#define   VBENumberOfBanks		  26
#define   VBEMemoryModel		  27
#define   VBEBankSize			  28
#define   VBENumberOfImagePages   29
#define   VBEReserved1			  30

	 // Direct Color fields (required for direct/6 and YUV/7 memory models)
#define   VBERedMaskSize		  31
#define   VBERedFieldPosition	  32
#define   VBEGreenMaskSize		  33
#define   VBEGreenFieldPosition   34
#define   VBEBlueMaskSize		  35
#define   VBEBlueFieldPosition	  36
#define   VBERsvdMaskSize		  37
#define   VBERsvdFieldPosition	  38
#define   VBEDirectColorModeInfo  39

	 // Mandatory information for VBE 2.0 and above
#define   VBEPhysBasePtr		  40
#define   VBEOffScreenMemOffset   44
#define   VBEOffScreenMemSize	  48
#define   VBEReserved2			  50


#endif
