#ifndef	__CDESKTOP_DIALOG_H__
#define	__CDESKTOP_DIALOG_H__

#include "group.h"
#include "misc.h"

#ifdef	__cplusplus
extern "C" {
#endif

/*

	dialog.h

		Dialog box

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	DIALOG STRUCTURES
*/

typedef struct
{
	DECLARE_DESKTOP_OBJECT;

	char	*fTitle;

	T_Group	*fGroup;
} T_Dialog;

/*
	FUNCTION PROTOTYPES
*/

extern	T_Dialog	*Dialog_Initialise( const char *aTitle, int aX1, int aY1, int aX2, int aY2, int aFlags,
									  			  bool ( *aEventHandler )( void*, T_EventRec* ));
extern	int	Dialog_ShowModal( T_Dialog *aDialog );
extern	void	Dialog_HandleLeftMousePress( T_Dialog *aDialog, int aColumn, int aRow );
extern	void	Dialog_HandleRightMousePress( T_Dialog *aDialog, int aColumn, int aRow );
extern	void	Dialog_HandleKeypress( T_Dialog *aDialog, int aKeypress );
extern	void	Dialog_RedrawObject( T_Dialog *aDialog, void *aObject );
extern	void	Dialog_FocusObject( T_Dialog *aDialog, void *aObject );
extern	void	Dialog_Kill( T_Dialog *aDialog );

extern	bool	Dialog_DefaultEventHandler( void *aDialog, T_EventRec *aEvent );

#ifdef	__cplusplus
}
#endif

#endif




