#include <conio.h>
#include <go32.h>
#include <stdlib.h>
#include <sys/farptr.h>

#include "desktop.h"
#include "group.h"
#include "misc.h"
#include "mouse.h"
#include "refresh.h"

/*

	refresh.c

		Refresh mechanism

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	STRUCTURE DEFINITIONS
*/

typedef	struct	S_DirtyRectangle
{
	int	fX1, fY1, fX2, fY2;	/* relative to physical screen */

	struct S_DirtyRectangle	*fNext;
} T_DirtyRectangle;

/*
	DATA
*/

static	T_DirtyRectangle	*sRefresh_DirtyRectangleList;

static	int	sScreen_CursorType = _NORMALCURSOR;
static	int	sScreen_CursorX = 0, sScreen_CursorY = 0;

int	gScreen_Width = 80;
int	gScreen_Height = 25;

/*
	FUNCTION	PROTOTYPES
*/

static	void	Refresh_RedrawRectangle( int aX1, int aY1, int aX2, int aY2 );

static	void	Screen_DrawBuffer( T_Buffer *aBuffer, int aX1, int aY1, int aX2, int aY2 );

/*
	FUNCTION	DEFINITIONS
*/

void	Refresh_Initialise( void )
{
	sRefresh_DirtyRectangleList = NULL;
}

void	Refresh_Update( void )
{
	while ( sRefresh_DirtyRectangleList != NULL )
	{
		Refresh_RedrawRectangle( sRefresh_DirtyRectangleList->fX1, sRefresh_DirtyRectangleList->fY1,
										 sRefresh_DirtyRectangleList->fX2, sRefresh_DirtyRectangleList->fY2 );
				 /// perhaps do all this to a buffer, then blit the whole thing to the screen?
		sRefresh_DirtyRectangleList =	sRefresh_DirtyRectangleList->fNext;
	}
}

inline	void	Refresh_AddDirtyRectangle( T_ObjectRec *aObject )
{
	if ( aObject->fOwner->fVisible )
	{
		Refresh_AddDirtyRectangleHelper( aObject->fOwner->fX1+aObject->fX1, aObject->fOwner->fY1+aObject->fY1,
													aObject->fOwner->fX1+aObject->fX2, aObject->fOwner->fY1+aObject->fY2 );
	}
}

void	Refresh_AddDirtyRectangleHelper( int aX1, int aY1, int aX2, int aY2 )
{
	int	lTempY;

	T_DirtyRectangle	*lTemp = sRefresh_DirtyRectangleList;

	if ( aX1 > aX2 || aY1 > aY2 )
	{
		return;
	}
	if ( aX1 < 0 )
	{
		aX1 = 0;
	}
	if ( aY1 < 0 )
	{
		aY1 = 0;
	}
	if ( aX2 >= gScreen_Width )
	{
		aX2 = gScreen_Width-1;
	}
	if ( aY2 >= gScreen_Height )
	{
		aY2 = gScreen_Height-1;
	}

	while ( lTemp != NULL )
	{
		if ( lTemp->fX1 <= aX2 && lTemp->fX2 > aX1 && lTemp->fY1 <= aY2 && lTemp->fY2 > aY1 )
		{
			if ( lTemp->fX1 > aX1 )
			{
				lTempY =	MAX( aY1, lTemp->fY1 );
				Refresh_AddDirtyRectangleHelper(	aX1, lTempY, lTemp->fX1-1, MIN( aY2+1, lTemp->fY2 )-1 );
			}
			if ( lTemp->fX2 <= aX2 )
			{
				lTempY = MAX( aY1, lTemp->fY1 );
				Refresh_AddDirtyRectangleHelper( lTemp->fX2, lTempY, aX2, MIN( aY2+1, lTemp->fY2 )-1 );
			}
			if ( lTemp->fY1 > aY1 )
			{
				Refresh_AddDirtyRectangleHelper( aX1, aY1, aX2, lTemp->fY1-1 );
			}
			if ( lTemp->fY2 <= aY2 )
			{
				Refresh_AddDirtyRectangleHelper( aX1, lTemp->fY2, aX2, aY2 );
			}
			return;
		}
		lTemp = lTemp->fNext;
	}

	P_InitVar( lTemp, T_DirtyRectangle );
	lTemp->fX1 = aX1;
	lTemp->fX2 = aX2;
	lTemp->fY1 = aY1;
	lTemp->fY2 = aY2;
	lTemp->fNext = sRefresh_DirtyRectangleList;
	sRefresh_DirtyRectangleList = lTemp;
}

void	Refresh_Terminate( void )
{
	T_DirtyRectangle	*lCurrent = sRefresh_DirtyRectangleList, *lPrev;

	while ( lCurrent != NULL )
	{
		lPrev = lCurrent;
		lCurrent = lCurrent->fNext;
		free( lPrev );
	}
	sRefresh_DirtyRectangleList = NULL;
}

void	Refresh_RedrawRectangle( int aX1, int aY1, int aX2, int aY2 )
{
	T_ObjectRec	*lRec = gDesktop->fObjectList;
	T_Buffer		*lBuffer = Buffer_Create( aX2-aX1+1, aY2-aY1+1 );

	if ( gDesktop->fVisible )
	{
		while ( lRec != NULL )
		{
			if ( lRec->fOwner != gEvent_ModalGroup )
			{
				DesktopObj_Draw( lRec, aX1, aY1, lBuffer );
			}
			lRec = lRec->fNext;
		}
	}

	if ( gEvent_ModalGroup->fVisible )
	{
		lRec = gEvent_ModalGroup->fObjectList;

		while ( lRec != NULL )
		{
			DesktopObj_Draw( lRec, aX1, aY1, lBuffer );
			lRec = lRec->fNext;
		}
	}
	Screen_DrawBuffer( lBuffer, aX1, aY1, aX2, aY2 );

	Buffer_Kill( lBuffer );
}

void	Screen_SetVideoMode( void )
{
	Mouse_TurnCursorOff();

	textmode( C80 );

	Mouse_SetMickey( 8, 8 );

	sScreen_CursorType = _NORMALCURSOR;

	if ( gDesktop->fVisible )
	{
		Screen_SetCursorType( _NOCURSOR );
		/// resize things and add dirty rectangles
	}
	Mouse_TurnCursorOn();
}

inline	void	Screen_SetCursorType( int aType )
{
	if ( sScreen_CursorType != aType )
	{
		sScreen_CursorType = aType;
		_setcursortype( sScreen_CursorType );
	}
}

inline	void	Screen_ShowCursor( void )
{
	if ( sScreen_CursorType != _NOCURSOR )
	{
		_setcursortype( sScreen_CursorType );
		gotoxy( sScreen_CursorX+1, sScreen_CursorY+1 );
	}
}

inline	void	Screen_HideCursor( void )
{
	if ( sScreen_CursorType != _NOCURSOR )
	{
		_setcursortype( _NOCURSOR );
	}
}

inline	void	Screen_SetCursorPosition( int aX, int aY )
{
	sScreen_CursorX = aX;
	sScreen_CursorY = aY;

	gotoxy( aX+1, aY+1 );
}

void	Screen_DrawBuffer( T_Buffer *aBuffer, int aX1, int aY1, int aX2, int aY2 )
{
   int	lOffs = 0xB8000+( aY1*gScreen_Width+aX1 )*2, x, y;
	byte	*lBuffer = aBuffer->fBuffer;

	bool	lMouseOn = gMouse_CursorOn && Mouse_Over( aX1, aY1, aX2, aY2 );

	if ( lMouseOn )
	{
		Mouse_TurnCursorOff();
	}

	_farsetsel( _dos_ds );
	for ( y = aY2-aY1+1; y--; )
   {
		for ( x = aX2-aX1+1; x--; )
      {
      	_farnspokew( lOffs, *( word* )lBuffer );
         lBuffer += 2;
         lOffs += 2;
      }
      lOffs += ( gScreen_Width-aX2+aX1-1 )*2;
   }
	if ( lMouseOn )
	{
		Mouse_TurnCursorOn();
	}
}

void	Screen_GetBuffer( byte *aBuffer, int aX, int aY, int aW, int aH )
{
   int	lOffs = 0xB8000+( aY*gScreen_Width+aX )*2, x, y;

	_farsetsel( _dos_ds );
	for ( y = aH; y--; )
   {
		for ( x = aW; x--; )
      {
      	*( word* )aBuffer = _farnspeekw( lOffs );
         aBuffer += 2;
         lOffs += 2;
      }
      lOffs += ( gScreen_Width-aW )*2;
   }
}

