#! /bin/sh

#
#  Small shell script to configure, compile check and install ffmpeg-5.N.N.tar.bz2
#  It assumes that it is started from the djgpp directory under the top src directory
#  and it creates the build directory called 0build under the top src directory.
#


export TMPDIR=${TMPDIR=.}
#export CFLAGS=-save-temps
#export WATT_ROOT=${WATT_ROOT='/dev/env/DJDIR/net/watt'}

DJGPP_DIR=$(cd $(dirname "$0") && pwd)

SRC_DIR=${DJGPP_DIR}/..

BUILD_DIR=${DJGPP_DIR}/../0build
rm -fr ${BUILD_DIR}
mkdir ${BUILD_DIR}
cd ${BUILD_DIR}

echo Configuring...
BEGIN=$(date)

#             --enable-network \
#             --enable-libvpx \
${SRC_DIR}/configure \
             --prefix=/dev/env/DJDIR \
             --enable-static \
             --enable-nonfree \
             --enable-gpl \
             --disable-iconv \
             --disable-asm \
             --disable-runtime-cpudetect \
             --disable-amd3dnow \
             --disable-amd3dnowext \
             --disable-mmx \
             --disable-mmxext \
             --disable-sse \
             --disable-sse2 \
             --disable-sse3 \
             --disable-ssse3 \
             --disable-sse4 \
             --disable-sse42 \
             --disable-avx \
             --enable-libxml2 \
             --enable-libmp3lame \
             --enable-libtheora \
             --enable-libvorbis \
             --enable-libopus \
             --enable-libx264 >& _c_log.txt

END=$(date)
printf "\n===================================\n\nbegin: ${BEGIN}\nend:   ${END}" >> _c_log.txt

echo Compiling...
BEGIN=$(date)
make V=0 >& _m_log.txt
END=$(date)
printf "\n===================================\n\nbegin: ${BEGIN}\nend:   ${END}" >> _m_log.txt

echo Checking...
BEGIN=$(date)
make V=1 check -k >& _mc_log.txt
END=$(date)
printf "\n===================================\n\nbegin: ${BEGIN}\nend:   ${END}" >> _mc_log.txt

echo Installing...
BEGIN=$(date)
if [ "x${INSTALL_PREFIX}" = "x" ]; then
  make install-progs install-data >& _mib_log.txt
  make install-headers install-libs >& _mil_log.txt
else
  bins_dir="${INSTALL_PREFIX}/_BINS_"
  libs_dir="${INSTALL_PREFIX}/_LIBS_"
  rm -vfr ${bins_dir} ${libs_dir}
  make install-progs install-data  prefix=${bins_dir} >& _mib_log.txt
  make install-headers install-libs  prefix=${libs_dir} >& _mil_log.txt
fi
END=$(date)
printf "\n===================================\n\nbegin: ${BEGIN}\nend:   ${END}" >> _mi_log.txt

