#include "InputBox.hpp"
#include "vocab.h"

using namespace jptui;

void	InputBox::init(const char* title, const char* defaultString, 
			     	   size_t displayLength, size_t maxLength, 
					   bool passwordMode)
{
	ButtonDescr	ds[3];
	ds[0].title_ = GetString(VOC_OK_CAPTION);
	ds[1].title_ = GetString(VOC_CANCEL_CAPTION);
	ds[2].title_ = 0;
	OkCancelBox::init(title, 2 + 1 + displayLength + 1 + 2, 2);
	TEditZone* ez = new TEditZone(window_.get(),
								  title[0] == 0 ? 1 : 2, 2,
								  0, 0, "", // caption
								  window_->m_get_width() - 6, maxLength, defaultString);
	if (passwordMode) {
		ez->set_password_mode(true);
	}
	editZone_.reset(ez);
	ez->m_set_focus();
}

const char*	InputBox::getString() const
{
	return editZone_->m_get_string();
}
