#include "MessageBox.hpp"
#include "strings.h"		// GetText...
#include "spchars.h"		// SST_ICON_...

using namespace jptui;

void	MessageBox::init(const char* title, int windowStyle, const char* text,
						 Icon icon, const ButtonDescr* ds, 
						 int defaultButton, int cancelButton,
						 const char* checkBoxTitle, bool checkBoxValue)
{
	size_t titleHeight = title[0] != 0 ? 1 : 0;
	const size_t MARGIN_X = 2;
	const size_t MARGIN_Y = 1;
	const size_t textHeight = GetTextHeight(text);
  	const size_t textWidth = GetTextWidth(text);
	size_t textX = MARGIN_X;
	size_t textY = titleHeight + MARGIN_Y;
	size_t iconX = MARGIN_X;
	size_t iconY = titleHeight + MARGIN_Y;
	const char*	iconText = getIconText(icon);
	size_t iconHeight = 0;
	size_t iconWidth = 0;
	if (iconText != 0) {
		iconHeight = GetTextHeight(iconText);
		iconWidth = GetTextWidth(iconText) + MARGIN_X;
		textX += iconWidth;
	}
	size_t height;
	if (textHeight > iconHeight) {
		height = textHeight;
		iconY += (textHeight - iconHeight) / 2;
	} else {
		height = iconHeight;
		textY += (iconHeight - textHeight) / 2;
	}
	if (checkBoxTitle != 0) {
		height += 2;
	}
	size_t reserveX = MARGIN_X + textWidth + iconWidth + MARGIN_X;
	size_t reserveY = MARGIN_Y + height;
	ButtonsBox::init(title, windowStyle, ds, defaultButton, cancelButton,
					 false, reserveX, reserveY);
	if (iconText != 0) {
		iconLabel_.reset(new TLabel(window_.get(), iconX, iconY, 
									iconWidth, iconHeight, iconText));
	}
	textLabel_.reset(new TLabel(window_.get(), textX, textY,
								textWidth, textHeight, text));
	if (checkBoxTitle != 0) {
		checkBox_.reset(new TCheckBox(window_.get(), MARGIN_X, height + 1,
									  iconWidth + textWidth, checkBoxTitle, 
									  checkBoxValue));
	}
}

bool	MessageBox::checkBoxValue()
{
	return checkBox_->m_is_checked();
}

const char*	MessageBox::getIconText(Icon icon)
{
	int id;
	switch (icon) {
   		case STOP_ICON:
			id = SST_ICON_STOP;
			break;
      	case QUESTION_ICON:
			id = SST_ICON_QUESTION;
			break;
      	case EXCLAMATION_ICON:
			id = SST_ICON_EXCLAMATION;
			break;
      	case INFORMATION_ICON:
			id = SST_ICON_INFORMATION;
			break;
		default:
			return 0;
	}
	return SPECIAL_STRING(id);
}
