/****************************************************************************/
/* CURSOR                                                                   */
/*--------------------------------------------------------------------------*/
/* Fonctions de manipulation du curseur texte                               */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/95                                                    */
/****************************************************************************/

#include <conio.h>

#include "Compat.h"
#include "Const.h"

#include "Mouse.h"
#include "Screen.h"

#include "Cursor.h"

#define INT_VIDEO 0x10

/*ͻ*/
/*                            VARIABLES STATIQUES                         */
/*ͼ*/

// Sauvegarde de la position du curseur (peut tre hors de l'cran)

static int s_x_cursor=1,
	   s_y_cursor=1;

// Aspect du curseur (INSERT/RECOVER)

static int s_cursor_style=INSERT_CURSOR;

// Visibilit : signifie que le curseur est visible ou qu'il le serait
//              s'il tait  l'intrieur de l'cran

static bool s_cursor_is_visible=true;

/*ͻ*/
/*                                 FONCTIONS                              */
/*ͼ*/

/****************************************************************************/
/* GetTextCursorStyle                                                       */
/*--------------------------------------------------------------------------*/
/* Retourne le style courant du curseur texte                               */
/****************************************************************************/

int GetTextCursorStyle()
{
  return (s_cursor_style);
}

/****************************************************************************/
/* SetTextCursorStyle                                                       */
/*--------------------------------------------------------------------------*/
/* Fixe le style du curseur texte                                           */
/****************************************************************************/

void SetTextCursorStyle(int cursor_style)
{
  __dpmi_regs regs;

  s_cursor_style=cursor_style;

  if (   (s_x_cursor>=1) && (s_x_cursor<=GetScreenWidth())
      && (s_y_cursor>=1) && (s_y_cursor<=GetScreenHeight()))
    {
      regs.h.ah=0x02;
      regs.h.bh=0;
      regs.h.dh=s_y_cursor-1;
      regs.h.dl=s_x_cursor-1;
     __dpmi_int(INT_VIDEO, &regs);
    }
  else
    cursor_style=_NOCURSOR;

  _setcursortype(cursor_style);
  s_cursor_is_visible=true;
}


/****************************************************************************/
/* HideTextCursor                                                           */
/*--------------------------------------------------------------------------*/
/* Cache le curseur texte                                                   */
/****************************************************************************/

void HideTextCursor()
{
  _setcursortype(_NOCURSOR);
  s_cursor_is_visible=false;
}

/****************************************************************************/
/* ShowTextCursor                                                           */
/*--------------------------------------------------------------------------*/
/* Montre le curseur texte                                                  */
/****************************************************************************/

void ShowTextCursor()
{
  SetTextCursorAt(s_x_cursor,s_y_cursor,s_cursor_style);
}

/****************************************************************************/
/* SetTextCursorAt                                                          */
/*--------------------------------------------------------------------------*/
/* Positionne le curseur sans/avec changement de son style                  */
/****************************************************************************/

void SetTextCursorAt(int x,int y)
{
  s_x_cursor=x;
  s_y_cursor=y;

  if (s_cursor_is_visible)
    SetTextCursorAt(x,y,s_cursor_style);
}

void SetTextCursorAt(int x,int y,int cursor_style)
{
  s_x_cursor=x;
  s_y_cursor=y;

  SetTextCursorStyle(cursor_style);
}

/****************************************************************************/
/* TextCursorIsVisible, GetXTextCursor, GetYTextCursor                      */
/*--------------------------------------------------------------------------*/
/* Retournent le style du curseur et sa position                            */
/****************************************************************************/

bool TextCursorIsVisible()
{
  return(s_cursor_is_visible);
}

int GetXTextCursor()
{
  return(s_x_cursor);
}

int GetYTextCursor()
{
  return(s_y_cursor);
}
