#
#  + Menu entries are not right justified correctly everywhere.
#  + SET's InfView (in RHIDE) doesn't like multiple Menus
#    (see main menu e.g.).
#    > JoinMenu.awk concatenates the menus now.
#  - The node "Character set Macros" still looks a bit strange
#    (references in function declarations).
#

#
# {Descriptions taken from jphc}
#
# In the source file, each help window is of form :
#
#   (1st column of each line)
# |
# ;Anything with a semicolon in the 1st column is a comment
# <help topic>Help window title (name and title of the help window)
# [<<]<help topic>              (name of the previous window in chain)
# [>>]<help topic>              (name of the next window in chain)
# [kw]key word 1                (key words of the window : appear in the index)
# ...
# [kw]key word n
#
# Help text follows until the following help window.
#
# Hypertext reference : [..key word]<help topic> embedded in the text
#                       (if there is no key word, the title of the corresponding
#                       help window is used instead).
#
# Any line of the source file can be one of the following macros :
# [@include(File)]    : Includes the file 'File'
#
#
# Notes :
# - <Contents> is the default help window
# - [<<]<> instead of [<<]<help topic> means the previous topic in the source file
# - [>>]<> instead of [>>]<help topic> means the next topic in the source file
#

BEGIN \
{
  # UsePXRef = 1      # 1: use @pxref instead of @menu/@endmenu
  CheckCase = 1     # 1: make sure that the case for topics and references matches
  NoIncludes = 1    # 1: don't include @include-files
  Comments = 0      # 1: don't remove comments
  SparseFormat = 1  # 1: don't use @format so often
  RightMargin = 77  # right margin column for menu entries

  Nested = 0+Nested

  print "Pass 1: counting lines, scanning topics and uptopics." >"/dev/stderr"
  while((getline < ARGV[1])>0)    # scan the file once, get Topics[] and UpTopics[]
  {
    ++Lines
    if(match($0,/^<.+>/))
    {
      Topics[++nTopics] = ThisTopic = substr($0,2,RLENGTH-2)
    }
    else while(match($0,/\]<[^>]+>/))
    {
      s = substr($0,RSTART+2,RLENGTH-3)
      if(""==UpTopics[s] && ThisTopic && s!=ThisTopic)
      {
        UpTopics[s] = ThisTopic
        # Dbg(2,"UpTopics[" s "] = " ThisTopic)
        # Dbg(3,"UpTopics[" s "] = " CorrectCase(ThisTopic))
      }
      $0 = substr($0,RSTART+RLENGTH)
    }
  }
  Topics[0] = "Top"       # just to make CorrectCase() happy
  Topics[0.1] = "(dir)"   # make CorrectCase() even happier
  if(CheckCase)
    for(s in UpTopics)
      UpTopics[CorrectCase(s)] = UpTopics[s]
  print "Pass 2: doing the real work." >"/dev/stderr"
}


function CorrectCase(Topic     ,i,s)
{
  if(!CheckCase)
    return Topic
  # find the correct case for the Topic given
  s = tolower(Topic)
  for(i in Topics)
    if(s==tolower(Topics[i]))
    {
#      Dbg(4,"CorrectCase(" Topic ")=\"" Topics[i] "\"")
      return Topics[i]
    }
  Error(3,"Topic " Topic " not found in Topics array.")
  return Topic
}


{
  if(!(FNR%10))
    printf("\b\b\b\b\b\b%3d%% ",100*FNR/Lines) >"CON"
}


1==FNR \
{
  FORMAT = "@f"
  ENDFORMAT = "@ef"
  MENU = "@menu"
  ENDMENU = "@end menu"
  if(!Nested)
  {
    print "@c -*-texinfo-*-  sorry, no TeX - just plain info mode"
    print "@c %**start of header"
    print "@setfilename jptui.info"
    print "@settitle JPTUI\n"

    print "@dircategory Libraries"
    print "@direntry"
    print "* JPTUI: (jptui)."
    print "        Jean-Pierre Delprat's Textmode User Interface library."
    print "@end direntry"

    print "@paragraphindent 1"
    print "@c %**end of header"

    print "@macro f"
    print "@format"
    print "@end macro"
    print "@macro ef"
    print "@end format"
    print "@end macro"
    StartFormat()
  }
}


InMenu && !/^\[kw\]/ && !/^\[\.\./ && !/^$/ && !/^;/ \
{
  EndMenu()
}


/^<.+>/ \
{
# <help topic>Help window title (name and title of the help window)

  i = index($0,">")
  if(!i)
    Error(1,"no `>':" $0)

  if("Top" == HelpTopic)
    StartMenu("Concept Index","An index of all concepts discussed.")

  PrevHelpTopic = HelpTopic  # ??? is this used anywhere
  HelpTopic = substr($0,2,i-2)   # this one has the correct case per definition
  sub(/^<.+>/,"")
  HelpWindowTitle = $0

  EndFormat()
  PrevTopic = NextTopic = ""
  TopicWasPrinted = 0
  PrintTopic()
  next
}


/^\[<<\]/ \
{
# [<<]<help topic>              (name of the previous window in chain)
# - [<<]<> instead of [<<]<help topic> means the previous topic in the source file

  sub(/^\[<<\]/,"")

  i = index($0,">")
  if(!i)
    Error(2,"no `>':" $0)
  PrevTopic = substr($0,2,i-2)
  if(!PrevTopic)
    PrevTopic = FindPrevTopic(HelpTopic) # PrevHelpTopic
  # Dbg(3,"PrevTopic=" PrevTopic)
  # passt
  next
}


/^\[>>\]/ \
{
# [>>]<help topic>              (name of the next window in chain)
# - [>>]<> instead of [>>]<help topic> means the next topic in the source file

  sub(/^\[>>\]/,"")

  i = index($0,">")
  if(!i)
    Error(2,"no `>':" $0)
  NextTopic = substr($0,2,i-2)
  if(!NextTopic)
    NextTopic = FindNextTopic(HelpTopic)
  next
}


/^[^\[<]/ \
{
  if(HelpTopic && !TopicWasPrinted)
  {
    # assuming new topic, spill out node name & next/prev node
    PrintTopic()
  }
}


function PrintTopic()
{
  EndFormat()
  EndTable()
  EndMenu()
  SectionName = HelpTopic
  FindPrevNextTopics(HelpTopic)
  UpTopic = FindUpTopic(HelpTopic)
  if("Contents"==HelpTopic)
  {
    PrevTopic = "(dir)"
    UpTopic   = "(dir)"
    HelpTopic = "Top"
    SectionName = "JPTUI"
  }
  if("Contents"==NextTopic)
    NextTopic = "Top"
  if("Contents"==PrevTopic)
    PrevTopic = "Top"
  if("Contents"==UpTopic)
    UpTopic = "Top"

  PrevTopic = CorrectCase(PrevTopic)
  NextTopic = CorrectCase(NextTopic)
  UpTopic = CorrectCase(UpTopic)
  print "\n@node " HelpTopic ", " NextTopic ", " PrevTopic ", " UpTopic
  print "@section " SectionName
  if("Top"==HelpTopic)
    print "@top"
  TopicWasPrinted = 1
  StartFormat()
}

/^\[kw\]/ \
{
# [kw]key word 1                (key words of the window : appear in the index)
# ...
# [kw]key word n

  KeywordForIndex = substr($0,5)
  MakeIndexEntry(KeywordForIndex)
  next
}


/\[\.\.[^\]]*\]/ \
{
# Hypertext reference : [..key word]<help topic> embedded in the text
#                       (if there is no key word, the title of the corresponding
#                       help window is used instead).

# translated into a menu if it starts in column 1 or else into a reference

  match($0,/\[\.\.[^\]]*\]/)
  UseXRef = (1!=RSTART)
  if(UseXRef)
  {
    OldRSTART = RSTART
    if(match($0,/^[ \t]*See[ \t].+\.?$/))
      UseXRef=2
    else if(match($0,/\(cf[ \t].+\)/))
    {
      UseXRef=3     # (cf [..]<Cursor Definitions>)
      sub(/\(cf /,"(")
      printf("%s",Escaped(substr($0,1,OldRSTART-4)))
    }
    else
    {
      UseXRef=4     # The [..key code]<Keycode Definitions>.
      printf("%s",Escaped(substr($0,1,OldRSTART-1)))
    }
  }
  while(GetKeyword(UseXRef)) { }
  if($0!="")
    PrintEscaped()
  next
}


/^\[@include\(.+\)\]/ \
{
#
# Any line of the source file can be one of the following macros :
# [@include(File)]    : Includes the file 'File'
#

# This is not really used anymore, since all the source must have been
# merged before to get the indices right.

  sub(/^\[@include\(/,"")
  sub(/\)\]/,"")
  NewFileName = $0

  EndMenu()

  EndFormat()
  # printf "@c including file: "
  PrintEscaped()
  if(!NoIncludes)
    system("gawk -f src2texi.awk -v Nested=" Nested+1 " -- " NewFileName)
  next
}


/^;/ \
{
# ;Anything with a semicolon in the 1st column is a comment

  if(Comments)
  {
    sub(/^;/,"")
    print "@c " $0
  }
  next
}


{
  # Help text follows until the following help window.
  StartFormat()
  PrintEscaped()
}


#
# Notes :
# - <Contents> is the default help window
#


END \
{
  EndFormat()
  EndTable()
  EndMenu()
  if(!Nested)
  {
    print "@node     Concept Index,     , Top, Top"
    print "@comment      node-name, next,  previous, up"
    print "@unnumbered Concept Index"
    print "@printindex cp"
    print "@bye"
  }
  printf("\b\b\b\b\b\b%3d%% \n",100*FNR/Lines) >"CON"
}


function Error(Nr,Msg)
{
  print "Error #" Nr " in line " FNR ": " Msg >"/dev/stderr"
}


function Dbg(Nr,Msg)
{
  print "Dbg #" Nr " in line " FNR ": " Msg >"/dev/stderr"
}


function PrintEscaped()
{
  IsTable = match($0,/[ĳ]/) || match($0,/ [:\.] /)

  OldIndentation = Indentation
  Indentation = match($0,/^ *[ĳ ] *./)
  if(Indentation)
    Indentation = RSTART+RLENGTH-1
  # Dbg(16,"Indentation=" Indentation)

  if(IsTable)
    StartTable()
  else if(Indentation && Indentation<OldIndentation)
    EndTable()
  if(!IsTable && match($0,/^[ \t]*\<\w+\>[ \t]*$/)) # only one word in a line
  {
    sub(/^[ \t]+/,"")
    printf("%*s\n",RightMargin-2,Escaped($0))
  }
  else
    print Escaped($0)
}


function Escaped(s)
{
  gsub(/@/,"@@",s)
  gsub(/{/,"@{",s)
  gsub(/}/,"@}",s)
  gsub(//,"-",s)
  gsub(//,"|",s)
  gsub(//,"+",s)
  gsub(//,">",s)
  if(!(InFormat || InTable))
    gsub(/  +/," ",s)
  return s
}

function StartTable()
{
  if(!InTable)
    print FORMAT
  InTable = 1
}

function EndTable()
{
  if(InTable)
    print ENDFORMAT
  InTable = 0
}


# ??? do all the FindXXXTopic() functions need CorrectCase() ???

function FindNextTopic(s      ,i)
{
  for(i=1; i<=nTopics; i++)
    if(Topics[i]==s)
      return Topics[i+1]
  return ""
}


function FindPrevTopic(s      ,i)
{
  for(i=1; i<=nTopics; i++)
    if(Topics[i]==s)
      return Topics[i-1]
  return ""
}


function FindPrevNextTopics(s    ,i)
{
  for(i=1; i<=nTopics; i++)
    if(Topics[i]==s)
    {
      PrevTopic = Topics[i-1]
      NextTopic = Topics[i+1]
      return ""
    }
  return ""
}


function FindUpTopic(s)
{
  return UpTopics[s]
}


function StartFormat()
{
  if(!SparseFormat)
    EndMenu()

  if(!SparseFormat && !InFormat)
  {
    print FORMAT
    InFormat = 1
  }
}


function EndFormat()
{
  if(InFormat)
    print ENDFORMAT
  InFormat = 0
}


function StartMenu(Keyword,KeywordDesc)    # KeywordDesc may be omitted
{
  if(!InMenu)
    if(!UsePXRef || /^\[kw\]/)
    {
       EndFormat()
       EndTable()
       print MENU
       StartedMenu = 1
    }
  if(!UsePXRef || /^\[kw\]/)
    PrintFilled("* " Keyword "::",KeywordDesc)
  else
    print "@pxref{" Keyword "}"
  InMenu = 1
}

function PrintFilled(s1,s2)
{
  printf("%s%*s\n",s1,RightMargin-length(s1),s2)
#  Dbg(23,s1 "<<<" RightMargin-length(s1))
}


function MakeIndexEntry(Keyword)
{
  sub(/^[ \t]+/,"",Keyword)
  gsub(/:/," ",Keyword)
  if(Keyword)
  {
    EndFormat()
    EndTable()
    print "@cindex " Keyword
  }
}


function EndMenu()
{
  if(InMenu)
    if(!UsePXRef || StartedMenu)
    {
      print ENDMENU
      StartedMenu = 0
    }
  InMenu = 0
}


function GetKeyword(IsXRef)
{

#[..An introduction to JPTUI]<Introduction>                             [..What's new in JPTUI]<What's new>
#[..How to get the latest version of JPTUI]<Latest Version>          [..What are all these files]<Files>

# Don't forget to read the [..technical information]<Technical Information> to avoid compiling
# problems.

  if(!match($0,/\[\.\.[^\]]*\]/))
    return 0
  if(4==RLENGTH)
    KeywordDesc = ""
  else
    KeywordDesc = substr($0,RSTART+3,RLENGTH-4)
  match($0,/<[^>]*>/)
  Keyword = CorrectCase(substr($0,RSTART+1,RLENGTH-2))
  $0 = substr($0,RSTART+RLENGTH)

  gsub(/[,]/,"",Keyword)
  gsub(/[,]/,"",KeywordDesc)
  if(IsXRef)
  {
    if(4==IsXRef)
      printf("%s", KeywordDesc " (@pxref{" Keyword "})")
    else if(3==IsXRef)
      printf("%s", "@pxref{" Keyword " , , " KeywordDesc "}")
    else
      print "@xref{" Keyword " , , " KeywordDesc "}."
    if(2==IsXRef)
      $0 = ""
    # Dbg(15,$0)
  }
  else
  {
    if(!KeywordDesc)
    {
      if(!match($0,/\[\.\.\]/))
      {
        match($0,/>[ \t]+[a-zA-Z]/)
        KeywordDesc = substr($0,RSTART+RLENGTH-1)
        $0 = ""
      }
    }
    StartMenu(Keyword, KeywordDesc)
  }
  return 1
}


