/****************************************************************************/
/* TPUSHBUT                                                                 */
/*--------------------------------------------------------------------------*/
/* Objet TPushButton (bouton  presser)                                     */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/95                                                    */
/****************************************************************************/

#include <conio.h>
#include <dos.h>
#include <stdlib.h>

#include "Const.h"
#include "JPDebug.h"

#include "JPAppli.h"

#include "Mouse.h"
#include "Strings.h"

#include "TWindow.h"

#include "TPushBut.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x, rel_y     : Coordonnes du bouton p/r au groupe                   */
/* width            : Largeur du bouton                                     */
/* caption          : Lgende du bouton (hot-key prcde de ~)             */
/* type             : Type du bouton (PB_DEFAULT,PB_CANCEL...)              */
/* enabled          : ENABLED si le bouton est activable (DISABLED sinon)   */
/****************************************************************************/

TPushButton::TPushButton(PObject parent,
			 int rel_x,int rel_y,
                         int width,
			 const char *caption,
			 int type,
			 TShadowChoice shadows,
			 bool enabled)
	    :TObject(parent,
		     OBJ_PUSH_BUTTON,
		     rel_x,rel_y,
		     width,1,
		     (parent==NULL)?((unsigned)WHITE):parent->m_get_background(),
		     caption,
                     enabled,
		     true,  // FOCUS_DEPENDING_ASPECT
		     true,  // CAN_BE_ENABLED
		     true),  // SIMPLE
		pressedAction_(this)
{
  // Shadows

  f_shadows = shadows;

  // Bouton non enfonc

  f_pressed=false;

  // Bouton enfonc par action sur le clavier

  f_pressed_by_key=false;

  // Bouton par dfaut/cancel button

  f_ok_button=false;
  f_cancel_button=false;

  if (type & PB_DEFAULT)
    f_window->m_set_default_button(this);

  if (type & PB_CANCEL)
    f_window->m_set_cancel_button(this);

}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TPushButton::~TPushButton()
{
  // Destruction des variables dynamiques

  f_window->m_button_destructed(this);
}

/****************************************************************************/
/* m_press                                                                  */
/*--------------------------------------------------------------------------*/
/* Presse le bouton                                                         */
/****************************************************************************/

void TPushButton::m_press()
{
  if (!f_enabled)
    return;

  if (!f_focused)
    {
      if (!m_set_focus())
        return;
    }

  f_pressed=true;
  m_display();

  JPRefresh();
  delay(PRESSURE_TIME_LENGTH);

  // Appui par action sur le clavier
  // -> attente du relchement

  if (f_pressed_by_key)
    {
      WaitKeyRelease();
      f_pressed_by_key=false;
    }

  f_pressed=false;
  m_display();
  JPRefresh();
	
		pressedAction_();
}

/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/

/****************************************/
/* m_lose_focus : Appele quand l'objet */
/* ------------   perd le focus         */
/****************************************/

void TPushButton::m_lose_focus()
{
  if (!f_focused)
    return;
  TObject::m_lose_focus();
  if (f_focused)
    return;

  // Si c'tait le ok_button

  if (f_ok_button)
    f_window->m_set_ok_button_to_default();
}

/****************************************/
/* m_take_focus : Appele quand l'objet */
/* ------------   prend le focus        */
/****************************************/

void TPushButton::m_take_focus()
{
  if (f_focused)
    return;
  TObject::m_take_focus();
  if (!f_focused)
    return;

  // L'objet devient le ok_button

  if (!f_ok_button)
    f_window->m_set_ok_button(this);
}



/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/**********************************************************************/
/* m_display_focus_depending_part : Affichage de la partie de l'objet */
/* ------------------------------   dont l'aspect dpend du focus     */
/**********************************************************************/

void TPushButton::m_display_focus_depending_part()
{
  m_display_caption();
}

/****************************************************************************/
/* m_display_caption                                                        */
/*--------------------------------------------------------------------------*/
/* Affichage de la lgende de l'objet                                       */
/****************************************************************************/

void TPushButton::m_display_caption()
{
  int color_attribute;
  char char1,char2;

  int x,y;

  // Si l'objet n'est pas ouvert, rien  faire

  if (!f_open)
    return;

  // Rcupration des coordonnes de l'objet dans sa fentre
  // et du style de la fentre

  x=m_get_x_in_window();
  y=m_get_y_in_window();

  // Affichage du push-button

  f_window->m_gotoxy(x,y);

  if (!f_pressed)
    {
      if (f_enabled)
	{
	  if ((f_focused) && (f_window->m_is_active()))
	    color_attribute=((WHITE<<4)+(unsigned)BLUE);
	  else
	    color_attribute=((LIGHTGRAY<<4)+(unsigned)BLACK);
	}
      else
	color_attribute=((LIGHTGRAY<<4)+(unsigned)CYAN);

      if ((!f_ok_button) || (!f_enabled) || (!f_window->m_is_active()))
	{
	  char1=' ';
	  char2=' ';
	}
      else
	{
	  char1=16;
	  char2=17;
	}

      f_window->m_textattr(color_attribute);
      f_window->m_putch(char1);
      f_window->m_put_caption(f_caption,
			    f_enabled,
			    f_width-2,
			    CENTERED_LEFT);
      f_window->m_putch(char2);



      f_window->m_textattr((f_background<<4)+(unsigned)BLACK);

      switch (f_shadows)
	{
	  case SHC_NONE       : f_window->m_putch(' ');
				break;
	  case SHC_HORIZONTAL : f_window->m_putch(' ');
				f_window->m_gotoxy(x,y+1);
				f_window->m_putnch(f_width,'');
				break;
	  case SHC_VERTICAL   : f_window->m_putch('');
				break;
	  case SHC_BOTH       : f_window->m_putch('');
				f_window->m_gotoxy(x+1,y+1);
				f_window->m_putnch(f_width,'');
				break;
	}
    }
  else
    {
// ???      JPDEBUG_TEST(DEBUG_ERROR_17,f_ok_button && f_focused);

      f_window->m_textattr((f_background<<4)+(unsigned)BLACK);

      f_window->m_putch(' ');

      f_window->m_textattr((WHITE<<4)+(unsigned)BLUE);

      f_window->m_putch(16);
      f_window->m_put_caption(f_caption,
			      f_enabled,
			      f_width-2,
			      CENTERED_LEFT);
      f_window->m_putch(17);

      if ((f_shadows==SHC_HORIZONTAL) || (f_shadows == SHC_BOTH))
	{
	  f_window->m_textattr((f_background<<4)+(unsigned)BLACK);
	  f_window->m_gotoxy(x,y+1);
	  f_window->m_putnch(f_width+1,' ');
	}
    }
}

/*************************************/
/* m_take_ok : Appele quand l'objet */
/* ---------   devient le ok_button  */
/*************************************/

void TPushButton::m_take_ok()
{
  if (!f_ok_button)
    {
      f_ok_button=true;
      m_display();
    }
}

/******************************************/
/* m_lose_ok : Appele quand l'objet perd */
/* ---------   son statut de ok_button    */
/******************************************/

void TPushButton::m_lose_ok()
{
  if (f_ok_button)
    {
      f_ok_button=false;
      m_display();
    }
}


/*********************************************************************/
/* m_left_button_pressed_event : L'utilisateur a cliqu dans l'objet */
/* ---------------------------   (l'objet tant activable).          */
/*                               Retourne true si l'objet est        */
/*                               intress par cet vnement.        */
/*********************************************************************/


bool TPushButton::m_left_button_pressed_event(int x,int y)
{
  int  button_state;
  int  x1,x2,y1,y2;

  if (!f_focused)
    {
      if (!m_set_focus())
        return false;
    }

  f_pressed=true;
  m_display();
  JPRefresh();

  x1=m_get_x();
  y1=m_get_y();
  x2=x1+f_width-1;
  y2=y1+f_height-1;

  GetMouseState(x,y,button_state);

  while (button_state==LEFT_BUTTON_PRESSED)
    {
      if ((x>=x1) && (x<=x2) && (y>=y1) && (y<=y2))
	{
	  if (!f_pressed)
	    {
	      f_pressed=true;
	      m_display();
	      JPRefresh();
	    }
	}
      else
	if (f_pressed)
	  {
	    f_pressed=false;
	    m_display();
	    JPRefresh();
	  }

      GetMouseState(x,y,button_state);
    }

  if (f_pressed)
    {
      f_pressed=false;
      m_display();
      JPRefresh();
		pressedAction_();
    }
  return true;
}

/************************************************************************/
/* m_key_pressed_event : L'utilisateur a appuy sur une touche          */
/* -------------------   qui est propose  l'objet (qui est activable).*/
/*                       Retourne true si l'objet est                   */
/*                       intress par cette touche.                    */
/************************************************************************/

bool TPushButton::m_key_pressed_event(TKey key)
{
  bool button_pressed=false;

  // Touches RETURN, ESC ou SPACE

  switch (key.character)
    {
      case RETURN: if (f_ok_button)
		     button_pressed=true;
		   break;
      case ESC   : if (f_cancel_button)
		     button_pressed=true;
		   break;
      case SPACE : if (f_focused)
		     button_pressed=true;
		   break;
    }

  // Appui sur la hot_key

  if ((!button_pressed) && (key.hot_character!=f_hot_key))
    return false;

  // La touche a provoqu l'enfoncement du bouton

  f_pressed_by_key=true;
  m_press();

  return true;
}

