/****************************************************************************/
/* TYPES                                                                    */
/*--------------------------------------------------------------------------*/
/* JPTUI types                                                              */
/*--------------------------------------------------------------------------*/
/* Author      : DELPRAT Jean-Pierre                                        */
/* Created on  : 06-DEC-94                                                  */
/* Modified on : 15-MAR-97                                                  */
/****************************************************************************/

#ifndef _TYPES_H_
#define _TYPES_H_

// Current types not defined in C

typedef unsigned char        byte;
typedef unsigned short int   word;
typedef unsigned char        u_char;

// Language

typedef enum
{
  NONE=-1,

  ENGLISH=0,
  FRENCH,
  GERMAN,
  ITALIAN,
  SPANISH,
  DUTCH,
  GREEK
}
TLanguage;

#define FIRST_LANGUAGE  ENGLISH
#define LAST_LANGUAGE   GREEK


// Zone definition

typedef struct { int x1,y1,x2,y2; } TIntZone;

// Scroll bars of an object

typedef enum { SBC_NONE,
	       SBC_HORIZONTAL,
	       SBC_VERTICAL,
	       SBC_BOTH }
	     TScrollbarChoice;


// Shadows of an object

typedef enum {
	       SHC_NONE,
	       SHC_HORIZONTAL,
	       SHC_VERTICAL,
	       SHC_BOTH }
	     TShadowChoice;

// Object types

class                           TApplication;
typedef TApplication            *PApplication;

class                           TCheckBox;
typedef TCheckBox               *PCheckBox;

class				TComboBox;
typedef TComboBox	        *PComboBox;

class                           TDecimalEditZone;
typedef TDecimalEditZone        *PDecimalEditZone;

class                           TEditZone;
typedef TEditZone               *PEditZone;

class                           TIntegerEditZone;
typedef TIntegerEditZone        *PIntegerEditZone;

class                           TFileListBox;
typedef TFileListBox            *PFileListBox;

class                           TFrame;
typedef TFrame                  *PFrame;

class                           TGroup;
typedef TGroup                  *PGroup;

class                           TLabel;
typedef TLabel                  *PLabel;

class                           TList;
typedef TList                   *PList;

class                           TListBox;
typedef TListBox                *PListBox;

class                           TMenu;
typedef TMenu                   *PMenu;

class                           TMenuBar;
typedef TMenuBar                *PMenuBar;

class                           TObject;
typedef TObject                 *PObject;

class                           TPushButton;
typedef TPushButton             *PPushButton;

class                           TRadioGroup;
typedef TRadioGroup             *PRadioGroup;

class                           TRadioButton;
typedef TRadioButton            *PRadioButton;

class                           TScrollBar;
typedef TScrollBar              *PScrollBar;

class                           TSimpleList;
typedef TSimpleList             *PSimpleList;

class                           TTab;
typedef TTab                    *PTab;

class                           TTabGroup;
typedef TTabGroup               *PTabGroup;

class                           TWindow;
typedef TWindow                 *PWindow;

class                           TGauge;
typedef TGauge                  *PGauge;

class                           TTextZone;
typedef TTextZone               *PTextZone;

class 				THelpWindow;
typedef THelpWindow 	        *PHelpWindow;

class 				THelpTextZone;
typedef THelpTextZone           *PHelpTextZone;


// TUIMaker object mirror class declarations

  #ifdef __TUIMAKER__
  class VApplication;
  class VCheckBox;
  class VComboBox;
  class VDecimalEditZone;
  class VEditZone;
  class VGauge;
  class VIntegerEditZone;
  class VFrame;
  class VGroup;
  class VLabel;
  class VList;
  class VListBox;
  class VMenu;
  class VMenuBar;
  class VObject;
  class VPasswordEditZone;
  class VPushButton;
  class VRadioGroup;
  class VRadioButton;
  class VScrollBar;
  class VSimpleList;
  class VTab;
  class VTabGroup;
  class VTextZone;
  class VWindow;
  #endif

//---------------------------------------

#endif
