#! /bin/sh

#
# Adjust the paths to files used in html pages
# and rename them to DOS licit names.
#
# List must be updated.
#

cd ../doc

# Map of file names that are illicit on DOS file system.
ILLICIT_NAMES_MAP=(
"ao_append_option.html         : append_option.html"

"ao_close.html                 : close.html"

"ao_default_driver_id.html     : default_driver_id.html"

"ao_device.html                : device.html"

"ao_driver_id.html             : drv_id.html"
"ao_driver_info_list.html      : drvinfo_list.html"
"ao_driver_info.html           : drvinfo.html"

"ao_file_extension.html        : file_extension.html"
"ao_free_options.html          : free_options.html"

"ao_info.html                  : info.html"
"ao_initialize.html            : initialize.html"
"ao_is_big_endian.html         : is_big_endian.html"

"ao_open_file.html             : open_file.html"
"ao_open_live.html             : open_live.html"
"ao_option.html                : option.html"

"ao_play.html                  : play.html"

"ao_plugin_close.html          : plgclose.html"
"ao_plugin_device_clear.html   : plgdev_clear.html"
"ao_plugin_device_init.html    : plgdev_init.html"
"ao_plugin_driver_info.html    : plgdrv_info.html"
"ao_plugin_file_extension.html : plgfile_extension.html"
"ao_plugin_open.html           : plgopen.html"
"ao_plugin_play.html           : plgplay.html"
"ao_plugin_set_option.html     : plgset_option.html"
"ao_plugin_test.html           : plgtest.html"

"ao_sample_format.html         : sample_format.html"
"ao_shutdown.html              : shutdown.html"
)

# Create sed script to modify the file content.
rm script.sed
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  echo "/<a href=\"${OLD_NAME}\">/s|${OLD_NAME}|${NEW_NAME}|g" >> script.sed
done

# Rename files and change their paths.
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  sed -f script.sed ${OLD_NAME} > ${NEW_NAME}
#  dtou ${NEW_NAME}
#  diff -aU1 ${OLD_NAME} ${NEW_NAME} > ${NEW_NAME}.txt
  rm -vf ${OLD_NAME}
done


# Change illicit file names in the rest of the files.
FILES=$(echo *.html)
for FILE in ${FILES}; do
  sed -f script.sed ${FILE} > ${FILE}.txt
  dtou ${FILE}.txt
  mv -vf ${FILE}.txt ${FILE}
done

# Adjust doc/Makefile.in accordingly.
cat > fix.sed << EOF
  s,^.*/s|,s|,;s/g$//
1i\\
/^doc_DATA[ 	]*=[ 	]*/,/^$/ {
\$a\\
}
EOF
sed -f fix.sed script.sed > script.txt
sed -f script.txt Makefile.in > makefile.txt
dtou Makefile.txt
mv -vf Makefile.txt Makefile.in

rm -f script.sed script.txt fix.sed
