
#include <Lib3d/Lib3d.H>
#include <Lib3d/internals/HrTimer.H>
#include <iostream.h>
#include <fstream.h>

extern void setup_fpu(void);

main()
{
    Viewport *viewport = Viewport::create(Device::create(320, 200, 8));


    if (!viewport) {
	cout << "Failed to create viewport" << endl;
	exit(1);
    }
    cout << *viewport << endl;

    setup_fpu();	// use low precision arith.


    World world;
    ModelBuilder ob;

    ifstream in("../models/teapot.nff");
    if (in.bad()) {
	cerr << "Couldn't open teapot.nff" << endl;
	exit(-1);
    }


    int i, j;


    Colour white = viewport->getColour(255,255,255);
    Colour blue = viewport->getColour(0,0,255);

    Colour *buf = new Colour[128*128];
    
    for (i = 0 ; i < 128 ; i++) {
	for (j = 0 ; j < 128 ; j++) {
	    if (((i/4) ^ (j/4)) & 1) {
		buf[i + j*128] = blue;
	    } else {
		buf[i + j*128] = white;
	    }
	}
    }

    Texture texture(buf, 7);

    ob.startModel();
    ob.setModelTexture(&texture);
    // ob.setColourfulMode(.2);	// Beachball mode
    ob.readNFF( in );

    Model *model = ob.endModel();
    world.adopt(model);

    cout << "Created object:\n" << *model << endl;

    Camera *camera = new Camera(world);
    camera->setParameters(3,100,15,1);
    world.setActiveCamera( *camera );

    
    Vector3 colour(1,1,1);	// A white light
    Vector3 direction(0,1,.5);
    Light *light = new Light(world);
    light->setParameters(colour, colour, direction);
    world.registerLight( *light );
    

    /*
    Vector3 colour2(1,0,.5);
    Vector3 direction2(1,0,0.5);
    Light *light2 = new Light(world);
    light2->setParameters(colour2, colour2, direction2);
    world.registerLight( *light2 );
    */

/*
    colour.assign(0,1,0);	// A green light
    direction.assign(0,-1,.5);
    light = new Light(world);
    light->setParameters(colour, colour, direction);
    world.registerLight( *light );
*/

    Pipeline *pipeline = 0;

    for (int n = 0 ; n < 4 ; n++) {

	switch (n) {
	case 3:
	    //continue;
	    delete pipeline;
	    pipeline = new TexturePipeline;
	    model->usePipeline(*pipeline);
	    cout << "Texture pipeline:" << endl;
	    break;

	case 2:
	    //continue;
	    delete pipeline;
	    pipeline = new WirePipeline;
	    model->usePipeline(*pipeline);
	    cout << "Wire pipeline:" << endl;
	    break;

	case 1:
	    //continue;
	    delete pipeline;
	    pipeline = new SmoothPipeline;
	    model->usePipeline(*pipeline);
	    cout << "Smooth pipeline:" << endl;
	    break;

	case 0:
	    //continue;
	    cout << "Flat pipeline:" << endl;
	    break;
	}

	Matrix34 transform;
	transform.setIdentity();
	model->setTransform(transform);
    
	Matrix34 tmp;
	Matrix34 scale;
	scale.setIdentity();

	HrTimer   clip("    Clipping");
	HrTimer noclip("Not clipping");
	HrTimer pageflip("Page flips");

	// Real close, lots of clipping

	transform.setRotation(-90, 1,0,0);
	scale.setRotation((4.56), 0, 1, 0);
	// scale.setRotation((4.56), 1, 1, 1);

	tmp.setTranslation(0,-1,-10);
	camera->setTransform(tmp);

	int nrFrames = 512;
	cout << "Rendering " << nrFrames << " frames: " << endl;
	clip.start();
	for (  i = 0 ; i < nrFrames ; i++ ) {
	    transform.premul(scale);
	    model->setTransform(transform);
	    world.renderHierarchy( *viewport );
	    viewport->swapBuffers();
	    //sleep(1);
	}
	clip.end();
	
	cout << clip << endl;
	cout << "\t" << (float(nrFrames)/clip.getElapsedSeconds()) 
	     << " frames per second" << endl;
	cout << setprecision(8) << "\t" 
	     << (float(nrFrames * model->getNrPolygons())/
		 clip.getElapsedSeconds()) 
	     << " polygons per second" << endl;


	// From a dignified distance,  no bounding box intersections.
	tmp.setTranslation(0,-1,-16);    
	camera->setTransform(tmp);
	transform.setRotation(-90, 1,0,0);
	scale.setRotation((4.56), 0, 1, 0);
	
	nrFrames = 1023;
	cout << "Rendering " << nrFrames << " frames: " << endl;
	noclip.start();
	for (  j = 0 ; j < nrFrames ; j++ ) {
	    transform.premul(scale);
	    model->setTransform(transform);
	    world.renderHierarchy( *viewport );
	    pageflip.start();
	    viewport->swapBuffers();
	    pageflip.end();
	}
	noclip.end();
	
	cout << pageflip << endl;
	cout << noclip << endl;
	cout << "\t" << (float(nrFrames)/noclip.getElapsedSeconds()) 
	     << " frames per second" << endl;
        cout << setprecision(8) << "\t" 
	     << (float(nrFrames*model->getNrPolygons())/
		 noclip.getElapsedSeconds()) 
	     << " polygons per second" << endl;

    }

    delete viewport;
}










