#include <Lib3d/Viewport.H>
#include <Lib3d/Model.H>
#include <Lib3d/ModelBuilder.H>
#include <Lib3d/World.H>
#include <Lib3d/Camera.H>
#include <Lib3d/Texture.H>
#include <Lib3d/TexturePipeline.H>
#include <iostream.h>

main()
{
    Device *device = Device::create(320, 200, 8);
    Viewport *viewport = Viewport::create( device );
    if (!viewport) {
	cout << "Couldn't create viewport" << endl;
	exit(1);
    }

    int i, j;
    Colour white = viewport->getColour(255,255,255);
    Colour blue = viewport->getColour(0,0,255);

    Colour *buf = new Colour[128*128];
    
    for (i = 0 ; i < 128 ; i++) {
	for (j = 0 ; j < 128 ; j++) {
	    if (((i/16) ^ (j/16)) & 1) {
		buf[i + j*128] = blue;
	    } else {
		buf[i + j*128] = white;
	    }
	}
    }

    Texture texture(buf, 7);


    uchar *dev = device->getBuffer();
    for (i = 0 ; i < 128 ; i++) {
	for (j = 0 ; j < 128 ; j++) {
	    dev[i+j*320] = buf[i+j*128];
	}
    }
    device->setDirty(0,0,320,200);
    device->swapBuffers();
    sleep(2);

    ModelBuilder ob;

    ob.startModel();

    int ind[4];
    ind[0] = ob.addVertex( 0,  0, 30, 0,  0);
    ind[1] = ob.addVertex(20, 20, 30, 127, 127);
    ind[2] = ob.addVertex(20,  0, 30, 127,  0);
    ind[3] = ob.addVertex(0,  20, 30, 0,  127);

    ob.calculatePolygonNormals();
    // ob.setColourfulMode(1,0);	// cycle through 7 bright colours 

    ob.addTriangle( ind[0], ind[1], ind[2] );
    //ob.addTriangle( ind[0], ind[3], ind[1] );

    ob.setModelTexture(&texture);

    Model *model = ob.endModel();
    
    TexturePipeline tp;
    model->usePipeline(tp);
    
    cout << "Created object:\n" << *model << endl;

    World world;
    Camera *camera = new Camera(world);
    camera->setParameters(1,200,45,1);
    world.adopt(model);
    world.setActiveCamera(*camera);

    cout << "Rendering: " << endl;
    
    Matrix34 transform;
    transform.setIdentity();
    model->setTransform(transform);
    
    Matrix34 tmp;
    Matrix34 scale;
    scale.setIdentity();

    // Backwards.
    tmp.setRotation((3.14), 1, 2, 0);
    scale.premul(tmp);
    tmp.setRotation((1.14), 0, 0, 1);
    scale.premul(tmp);


    Matrix34 t2;
    t2.setTranslation(10,10,-40);
    camera->setTransform(t2);

    for ( i = 0 ; i < 4000 ; i++ ) {
	transform.premul(scale);
	model->setTransform(transform);
	// if (i < 1012) continue;
	// fprintf(stderr, "%d\n", i);
	world.renderHierarchy( *viewport );
	viewport->swapBuffers();
    }

    delete viewport;
}










