// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef NodeClass
#define NodeClass

#include <Lib3d/Vector.H>
#include <Lib3d/Matrix.H>   
#include <Lib3d/internals/Debuggable.H>

class Light;
class Viewport;
class World;

enum {
    lightingChange,
    lightColourChange,
    uniformDiffuse,
};

class Node : public Debuggable
{
friend class World;

public:
    Node();
    Node( Node &parent );
    virtual ~Node();

    const char *getName() const { return "Node"; }
    
    void adopt( Node * );

    Node *getNextNamed( const char *name );

    void setTransform( const Matrix34 & );
    void setLookAt(const Vector3 &from,
		   const Vector3 &at,
		   const Vector3 &up);
		   

    void recalculateHierarchy( bool, const Matrix34 & );

protected:
    virtual void render( Viewport &, const Light *, uint nrLights, uint flags );
    virtual void recalculateTransforms( const Matrix34 & );

protected:
    void setDirty(); 
    bool isDirty() const;
    bool isTarnished() const;
    const Node *getWorld() const;
    Node *getWorld();
    void calculateObjectToWorld( Matrix34 & ) const;

private:
    bool dirtyTransform;

protected:
    Matrix34 objectToParent;	       
    Matrix34 objectToCvv;	       
   
    Node *child;
    Node *next;
    Node *parent;
  
    void *extensions;		// Room for future expansion.

protected:
    // What is this doing here?
    static float D;
    static Matrix4 cvvToDevice;
};

inline bool
Node::isDirty() const
{
    return dirtyTransform;
}

inline void 
Node::setDirty()
{
    dirtyTransform = true;
}


#endif

      
	 


















