// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef MaterialClass
#define MaterialClass

#include <Lib3d/Vector.H>

class ColourRamp;

// Extending the renderer to handle textures and shading is going to 
// require some changes here (and elsewhere).

struct Material
{
    Material() : ramp(0) { }
    ~Material();

    void setParameters(const Vector3 &colour,
		       float Ka, float Kd, 
		       float c1, float c2, float c3);

    Vector3 colour;
    float Ka;
    float Kd;
    float c1, c2, c3;

    // Derived values:
    Vector3 ambient;
    Vector3 diffuse;
    ColourRamp *ramp;
};


#endif
