// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef ZBufferClass
#define ZBufferClass

#include <Lib3d/Device.H>
#include <Lib3d/internals/types.H>
#include <Lib3d/internals/Debuggable.H>

class ZBuffer : public Debuggable
{
public:
    ZBuffer( uint width, uint height );
    ZBuffer( const Device & );
    ~ZBuffer();

    const char *getName() const { return "ZBuffer"; }

    void clear();
    void resize(uint width, uint height);
    
    uint *getBuffer()         const { return buffer; }
    uint  getWidth()          const { return width;  }
    uint  getHeight()         const { return height;  }
    uint  getGenerationMask() const { return generationMask;  }
    void  setDirty(uint, uint, uint, uint);
    float getScale() const { return scale; }
    uint  getStart() const { return start; }

protected:
    static const float scale;
    static const uint start;

    void cleanBuffer();
    ostream &print( ostream &out ) const;
    
private:
    enum { generationIncrement = 0x01000000 };

    uint *buffer;
    uint generationMask;
    uint width; 
    uint height;
    uint active;
    uint size;
    uint xmin, xmax;
    uint ymin, ymax;
};

inline void 
ZBuffer::setDirty(uint xn, uint yn, uint xx, uint yx )
{
    if (xmin > xn) xmin = xn;
    if (xmax < xx) xmax = xx;
    if (ymin > yn) ymin = yn;
    if (ymax < yx) ymax = yx;
}

#endif


