/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: _sjctype.c,v 1.1 1996/06/21 13:30:01 jack Exp $ */

#include <mbctype.h>
#include <mbprvt.h>

#define MBCNUM ((1<<8)+1)

unsigned char __sjis_mbctype[MBCNUM] =
{
  0, /* EOF */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 00-0f */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 10-1f */

  _MB_CBLANK, /* 20 */
  _MB_CPUNCT, /* 21 */
  _MB_CPUNCT, /* 22 */
  _MB_CPUNCT, /* 23 */
  _MB_CPUNCT, /* 24 */
  _MB_CPUNCT, /* 25 */
  _MB_CPUNCT, /* 26 */
  _MB_CPUNCT, /* 27 */
  _MB_CPUNCT, /* 28 */
  _MB_CPUNCT, /* 29 */
  _MB_CPUNCT, /* 2a */
  _MB_CPUNCT, /* 2b */
  _MB_CPUNCT, /* 2c */
  _MB_CPUNCT, /* 2d */
  _MB_CPUNCT, /* 2e */
  _MB_CPUNCT, /* 2f */

  _MB_CDIGIT, /* 30 */
  _MB_CDIGIT, /* 31 */
  _MB_CDIGIT, /* 32 */
  _MB_CDIGIT, /* 33 */
  _MB_CDIGIT, /* 34 */
  _MB_CDIGIT, /* 35 */
  _MB_CDIGIT, /* 36 */
  _MB_CDIGIT, /* 37 */
  _MB_CDIGIT, /* 38 */
  _MB_CDIGIT, /* 39 */
  _MB_CPUNCT, /* 3a */
  _MB_CPUNCT, /* 3b */
  _MB_CPUNCT, /* 3c */
  _MB_CPUNCT, /* 3d */
  _MB_CPUNCT, /* 3e */
  _MB_CPUNCT, /* 3f */

  _MB_CPUNCT|_MB_TRAIL, /* 40 */
  _MB_CALPHA|_MB_TRAIL, /* 41 */
  _MB_CALPHA|_MB_TRAIL, /* 42 */
  _MB_CALPHA|_MB_TRAIL, /* 43 */
  _MB_CALPHA|_MB_TRAIL, /* 44 */
  _MB_CALPHA|_MB_TRAIL, /* 45 */
  _MB_CALPHA|_MB_TRAIL, /* 46 */
  _MB_CALPHA|_MB_TRAIL, /* 47 */
  _MB_CALPHA|_MB_TRAIL, /* 48 */
  _MB_CALPHA|_MB_TRAIL, /* 49 */
  _MB_CALPHA|_MB_TRAIL, /* 4a */
  _MB_CALPHA|_MB_TRAIL, /* 4b */
  _MB_CALPHA|_MB_TRAIL, /* 4c */
  _MB_CALPHA|_MB_TRAIL, /* 4d */
  _MB_CALPHA|_MB_TRAIL, /* 4e */
  _MB_CALPHA|_MB_TRAIL, /* 4f */

  _MB_CALPHA|_MB_TRAIL, /* 50 */
  _MB_CALPHA|_MB_TRAIL, /* 51 */
  _MB_CALPHA|_MB_TRAIL, /* 52 */
  _MB_CALPHA|_MB_TRAIL, /* 53 */
  _MB_CALPHA|_MB_TRAIL, /* 54 */
  _MB_CALPHA|_MB_TRAIL, /* 55 */
  _MB_CALPHA|_MB_TRAIL, /* 56 */
  _MB_CALPHA|_MB_TRAIL, /* 57 */
  _MB_CALPHA|_MB_TRAIL, /* 58 */
  _MB_CALPHA|_MB_TRAIL, /* 59 */
  _MB_CALPHA|_MB_TRAIL, /* 5a */
  _MB_CPUNCT|_MB_TRAIL, /* 5b */
  _MB_CPUNCT|_MB_TRAIL, /* 5c */
  _MB_CPUNCT|_MB_TRAIL, /* 5d */
  _MB_CPUNCT|_MB_TRAIL, /* 5e */
  _MB_CPUNCT|_MB_TRAIL, /* 5f */

  _MB_CPUNCT|_MB_TRAIL, /* 60 */
  _MB_CALPHA|_MB_TRAIL, /* 61 */
  _MB_CALPHA|_MB_TRAIL, /* 62 */
  _MB_CALPHA|_MB_TRAIL, /* 63 */
  _MB_CALPHA|_MB_TRAIL, /* 64 */
  _MB_CALPHA|_MB_TRAIL, /* 65 */
  _MB_CALPHA|_MB_TRAIL, /* 66 */
  _MB_CALPHA|_MB_TRAIL, /* 67 */
  _MB_CALPHA|_MB_TRAIL, /* 68 */
  _MB_CALPHA|_MB_TRAIL, /* 69 */
  _MB_CALPHA|_MB_TRAIL, /* 6a */
  _MB_CALPHA|_MB_TRAIL, /* 6b */
  _MB_CALPHA|_MB_TRAIL, /* 6c */
  _MB_CALPHA|_MB_TRAIL, /* 6d */
  _MB_CALPHA|_MB_TRAIL, /* 6e */
  _MB_CALPHA|_MB_TRAIL, /* 6f */

  _MB_CALPHA|_MB_TRAIL, /* 70 */
  _MB_CALPHA|_MB_TRAIL, /* 71 */
  _MB_CALPHA|_MB_TRAIL, /* 72 */
  _MB_CALPHA|_MB_TRAIL, /* 73 */
  _MB_CALPHA|_MB_TRAIL, /* 74 */
  _MB_CALPHA|_MB_TRAIL, /* 75 */
  _MB_CALPHA|_MB_TRAIL, /* 76 */
  _MB_CALPHA|_MB_TRAIL, /* 77 */
  _MB_CALPHA|_MB_TRAIL, /* 78 */
  _MB_CALPHA|_MB_TRAIL, /* 79 */
  _MB_CALPHA|_MB_TRAIL, /* 7a */
  _MB_CPUNCT|_MB_TRAIL, /* 7b */
  _MB_CPUNCT|_MB_TRAIL, /* 7c */
  _MB_CPUNCT|_MB_TRAIL, /* 7d */
  _MB_CPUNCT|_MB_TRAIL, /* 7e */
  0, /* 7f */

  _MB_TRAIL, /* 80 */
  _MB_LEAD|_MB_TRAIL, /* 81 */
  _MB_LEAD|_MB_TRAIL, /* 82 */
  _MB_LEAD|_MB_TRAIL, /* 83 */
  _MB_LEAD|_MB_TRAIL, /* 84 */
  _MB_LEAD|_MB_TRAIL, /* 85 */
  _MB_LEAD|_MB_TRAIL, /* 86 */
  _MB_LEAD|_MB_TRAIL, /* 87 */
  _MB_LEAD|_MB_TRAIL, /* 88 */
  _MB_LEAD|_MB_TRAIL, /* 89 */
  _MB_LEAD|_MB_TRAIL, /* 8a */
  _MB_LEAD|_MB_TRAIL, /* 8b */
  _MB_LEAD|_MB_TRAIL, /* 8c */
  _MB_LEAD|_MB_TRAIL, /* 8d */
  _MB_LEAD|_MB_TRAIL, /* 8e */
  _MB_LEAD|_MB_TRAIL, /* 8f */

  _MB_LEAD|_MB_TRAIL, /* 90 */
  _MB_LEAD|_MB_TRAIL, /* 91 */
  _MB_LEAD|_MB_TRAIL, /* 92 */
  _MB_LEAD|_MB_TRAIL, /* 93 */
  _MB_LEAD|_MB_TRAIL, /* 94 */
  _MB_LEAD|_MB_TRAIL, /* 95 */
  _MB_LEAD|_MB_TRAIL, /* 96 */
  _MB_LEAD|_MB_TRAIL, /* 97 */
  _MB_LEAD|_MB_TRAIL, /* 98 */
  _MB_LEAD|_MB_TRAIL, /* 99 */
  _MB_LEAD|_MB_TRAIL, /* 9a */
  _MB_LEAD|_MB_TRAIL, /* 9b */
  _MB_LEAD|_MB_TRAIL, /* 9c */
  _MB_LEAD|_MB_TRAIL, /* 9d */
  _MB_LEAD|_MB_TRAIL, /* 9e */
  _MB_LEAD|_MB_TRAIL, /* 9f */

  _MB_TRAIL, /* a0 */
  _MB_PUNCT|_MB_TRAIL, /* a1 */
  _MB_PUNCT|_MB_TRAIL, /* a2 */
  _MB_PUNCT|_MB_TRAIL, /* a3 */
  _MB_PUNCT|_MB_TRAIL, /* a4 */
  _MB_PUNCT|_MB_TRAIL, /* a5 */
  _MB_SINGLE|_MB_TRAIL, /* a6 */
  _MB_SINGLE|_MB_TRAIL, /* a7 */
  _MB_SINGLE|_MB_TRAIL, /* a8 */
  _MB_SINGLE|_MB_TRAIL, /* a9 */
  _MB_SINGLE|_MB_TRAIL, /* aa */
  _MB_SINGLE|_MB_TRAIL, /* ab */
  _MB_SINGLE|_MB_TRAIL, /* ac */
  _MB_SINGLE|_MB_TRAIL, /* ad */
  _MB_SINGLE|_MB_TRAIL, /* ae */
  _MB_SINGLE|_MB_TRAIL, /* af */

  _MB_PUNCT|_MB_TRAIL, /* b0 */
  _MB_SINGLE|_MB_TRAIL, /* b1 */
  _MB_SINGLE|_MB_TRAIL, /* b2 */
  _MB_SINGLE|_MB_TRAIL, /* b3 */
  _MB_SINGLE|_MB_TRAIL, /* b4 */
  _MB_SINGLE|_MB_TRAIL, /* b5 */
  _MB_SINGLE|_MB_TRAIL, /* b6 */
  _MB_SINGLE|_MB_TRAIL, /* b7 */
  _MB_SINGLE|_MB_TRAIL, /* b8 */
  _MB_SINGLE|_MB_TRAIL, /* b9 */
  _MB_SINGLE|_MB_TRAIL, /* ba */
  _MB_SINGLE|_MB_TRAIL, /* bb */
  _MB_SINGLE|_MB_TRAIL, /* bc */
  _MB_SINGLE|_MB_TRAIL, /* bd */
  _MB_SINGLE|_MB_TRAIL, /* be */
  _MB_SINGLE|_MB_TRAIL, /* bf */

  _MB_SINGLE|_MB_TRAIL, /* c0 */
  _MB_SINGLE|_MB_TRAIL, /* c1 */
  _MB_SINGLE|_MB_TRAIL, /* c2 */
  _MB_SINGLE|_MB_TRAIL, /* c3 */
  _MB_SINGLE|_MB_TRAIL, /* c4 */
  _MB_SINGLE|_MB_TRAIL, /* c5 */
  _MB_SINGLE|_MB_TRAIL, /* c6 */
  _MB_SINGLE|_MB_TRAIL, /* c7 */
  _MB_SINGLE|_MB_TRAIL, /* c8 */
  _MB_SINGLE|_MB_TRAIL, /* c9 */
  _MB_SINGLE|_MB_TRAIL, /* ca */
  _MB_SINGLE|_MB_TRAIL, /* cb */
  _MB_SINGLE|_MB_TRAIL, /* cc */
  _MB_SINGLE|_MB_TRAIL, /* cd */
  _MB_SINGLE|_MB_TRAIL, /* ce */
  _MB_SINGLE|_MB_TRAIL, /* cf */

  _MB_SINGLE|_MB_TRAIL, /* d0 */
  _MB_SINGLE|_MB_TRAIL, /* d1 */
  _MB_SINGLE|_MB_TRAIL, /* d2 */
  _MB_SINGLE|_MB_TRAIL, /* d3 */
  _MB_SINGLE|_MB_TRAIL, /* d4 */
  _MB_SINGLE|_MB_TRAIL, /* d5 */
  _MB_SINGLE|_MB_TRAIL, /* d6 */
  _MB_SINGLE|_MB_TRAIL, /* d7 */
  _MB_SINGLE|_MB_TRAIL, /* d8 */
  _MB_SINGLE|_MB_TRAIL, /* d9 */
  _MB_SINGLE|_MB_TRAIL, /* da */
  _MB_SINGLE|_MB_TRAIL, /* db */
  _MB_SINGLE|_MB_TRAIL, /* dc */
  _MB_SINGLE|_MB_TRAIL, /* dd */
  _MB_PUNCT|_MB_TRAIL, /* de */
  _MB_PUNCT|_MB_TRAIL, /* df */

  _MB_LEAD|_MB_TRAIL, /* e0 */
  _MB_LEAD|_MB_TRAIL, /* e1 */
  _MB_LEAD|_MB_TRAIL, /* e2 */
  _MB_LEAD|_MB_TRAIL, /* e3 */
  _MB_LEAD|_MB_TRAIL, /* e4 */
  _MB_LEAD|_MB_TRAIL, /* e5 */
  _MB_LEAD|_MB_TRAIL, /* e6 */
  _MB_LEAD|_MB_TRAIL, /* e7 */
  _MB_LEAD|_MB_TRAIL, /* e8 */
  _MB_LEAD|_MB_TRAIL, /* e9 */
  _MB_LEAD|_MB_TRAIL, /* ea */
  _MB_LEAD|_MB_TRAIL, /* eb */
  _MB_LEAD|_MB_TRAIL, /* ec */
  _MB_LEAD|_MB_TRAIL, /* ed */
  _MB_LEAD|_MB_TRAIL, /* ee */
  _MB_LEAD|_MB_TRAIL, /* ef */

  _MB_LEAD|_MB_TRAIL, /* f0 */
  _MB_LEAD|_MB_TRAIL, /* f1 */
  _MB_LEAD|_MB_TRAIL, /* f2 */
  _MB_LEAD|_MB_TRAIL, /* f3 */
  _MB_LEAD|_MB_TRAIL, /* f4 */
  _MB_LEAD|_MB_TRAIL, /* f5 */
  _MB_LEAD|_MB_TRAIL, /* f6 */
  _MB_LEAD|_MB_TRAIL, /* f7 */
  _MB_LEAD|_MB_TRAIL, /* f8 */
  _MB_LEAD|_MB_TRAIL, /* f9 */
  _MB_LEAD|_MB_TRAIL, /* fa */
  _MB_LEAD|_MB_TRAIL, /* fb */
  _MB_LEAD|_MB_TRAIL, /* fc */
  0, /* fd */
  0, /* fe */
  0, /* ff */
};
