/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbsdec.c,v 1.1 1996/06/30 13:25:00 jack Exp $ */

#include <stddef.h>
#include <mbstring.h>

/* us: pointer to string */
/* up: current pointer */

unsigned char *
_mbsdec (const unsigned char *us, const unsigned char *up)
{
  if (up <= us)
    return NULL;

  /* check previous character */
  switch (_mbsbtype (us, (size_t) (up - us - 1)))
    {
    case _MBC_LEAD:
      /* current was invalid multibyte */
      return NULL;

    case _MBC_TRAIL:
      /* decrease 2 bytes */
      return (unsigned char *) (up - 2);

    case _MBC_SINGLE:
      /* decrease 1 byte */
      return (unsigned char *) (up - 1);
    }

  /* otherwise invalid */
  return NULL;
}
