/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: iswctype.c,v 1.2 1996/10/27 13:23:27 jack Exp $ */

#include <stddef.h>
#include <wctype.h>
#include <wcprvt.h>

#define WCRANGE (0)
#define MINRANGE (0)
#define MAXRANGE (1)
#define FOUND (1)
#define NOTFOUND (0)

static int
searchchr (wchar_t *wchars, int num, wint_t wc)
{
  int l, m, r;
  int s;
  int c1, c2;

  l = 0; /* left(start) point */
  m = 0; /* middle point */
  r = num - 1; /* right(end) point */
  c2 = (int) wc;

  /* binary search */
  while (l <= r)
    {
      m = (l + r) / 2;
      c1 = (int) wchars[m];
      s = c1 - c2;
      if (s < 0)
	l = m + 1;
      else if (s > 0)
	r = m - 1;
      else
	return FOUND;
    }

  return NOTFOUND;
}

int
iswctype (wint_t wc, wctype_t type)
{
  struct __wcclass *wcclass;
  int num;
  int i;

  /* verify type */
  if (type == 0 || type < 0 || type > __wcprops_num)
    return NOTFOUND;

  /* get classification */
  wcclass = __wcprops[type - 1]->wcclass;

  /* search */
  for (i = 0; (num = wcclass[i].num) >= 0; i++)
    {
      if (num == WCRANGE)
	{
	  /* in range */
	  if (wc >= wcclass[i].wchars[MINRANGE] && wc <= wcclass[i].wchars[MAXRANGE])
	    return FOUND;
	}
      else
	{
	  /* in enumeration */
	  if (searchchr (wcclass[i].wchars, num, wc) != NOTFOUND)
	    return FOUND;
	}
    }

  return NOTFOUND;
}
