/*************************************************************
 *****************    ===FONTVIEW.EXE===    ******************
 *************************************************************
      Copyright (c)1996 Grafik Software by Malcolm Taylor

 -> FONTWIN.CC
 -> Source for FontWindow class.
*/

#include <stdio.h>
#include "fontwin.h"
#include <tws/button.h>

DEFINE_RESPONSE_TABLE(FontWindow,Window)
   E_BUTTONUP(ID_SYSBOX,CloseWindow)
END_RESPONSE_TABLE

FontWindow::FontWindow(char name[],int width,int height,int chwidth,FONT *f):
   Window(NULL,name,40,40,MIN(40+width+BORDER_WIDTH*2+2,ws.GetDeskWidth()),MIN(40+height+CAPTION_HEIGHT+BORDER_WIDTH+34,ws.GetDeskHeight()),WA_VISABLE | WA_BORDER | WA_CAPTION | WA_SYSBOX | WA_SAVEAREA)
   ,font(f)
   ,width(chwidth)
{
   char temp[100];

   type=new StaticText(this,font->isfixed?"Font is fixed":"Font is proportional",20,CAPTION_HEIGHT+1,w-40);
   sprintf(temp,"Width:%d, Height:%d, Max width:%d",font->width,font->height,chwidth);
   info=new StaticText(this,temp,10,CAPTION_HEIGHT+17,w-20);
}

FontWindow::~FontWindow()
{
   delete info;
   delete type;
}

void
FontWindow::PaintWindow(int x1,int y1,int x2,int y2)
{
   int x,y;

   Window::PaintWindow(x1,y1,x2,y2);

   ViewBuffer *temp=GetSubBuffer(x1,y1,x2,y2);

   for(y=0;y<6;y++)
   {
      for(x=0;x<16;x++)
         WriteChar(temp,x*(width+2)+BORDER_WIDTH+2,y*(font->height+2)+CAPTION_HEIGHT+34,1,font,(y+2)*16+x);
   }
   DeleteBuffer(temp);
}

void
FontWindow::CloseWindow()
{
   ws.QueueEvent(parent,event(W_REMOVE_CHILD,(int)this));
}

void ViewFont(char *name)
{
   FONT *font=LoadFont(name);
   FontWindow *temp;
   int width=0,f;

   if(!font)
      return;

   if(font->isfixed)
      width=font->width;
   else
   {
      for(f=font->min_char;f<=font->max_char;f++)
         width=MAX(font->widths[f-font->min_char],width);
   }
   temp=new FontWindow(name,(width+2)*16,(font->height+2)*6,width,font);
   temp->Paint();
   temp->RefreshWindow();
}

