/*************************************************************
 ****************    ===Picture Viewer===    *****************
 *************************************************************
      Copyright (c)1996 Grafik Software by Malcolm Taylor

 -> PICVIEW.H
 -> Declarations for menus and main classes.
*/

#ifndef _picview_h
#define _picview_h

#include <tws/system.h>
#include <tws/menu.h>

#define ID_SEPARATOR    -1

#define ID_FILE_OPEN             1
#define ID_FILE_SAVE             2
#define ID_FILE_SAVE_AS          3
#define ID_SHELL_TO_DOS          4
#define ID_FILE_EXIT             5
#define ID_FILE_SAVE_AS_BITMAP   20
#define ID_FILE_SAVE_AS_TARGA    21

#define ID_IMAGE_COMPRESS  100
#define ID_IMAGE_OPTIONS   101

#define ID_HELP_CONTENTS   200

PopupMenuRes SaveAsMenuRes[]={
   {"Windows &Bitmap",ID_FILE_SAVE_AS_BITMAP,0,0},
   {"&Targa",ID_FILE_SAVE_AS_TARGA,0,0}
};

PopupMenuRes FileMenuRes[]={
   {"&Open",ID_FILE_OPEN,0,0},
   {"&Save",ID_FILE_SAVE,0,0},
   {"Save &As",ID_FILE_SAVE_AS,2,SaveAsMenuRes},
   {0,ID_SEPARATOR,0,0},
   {"Shell to &Dos",ID_SHELL_TO_DOS,0,0},
   {0,ID_SEPARATOR,0,0},
   {"E&xit",ID_FILE_EXIT,0,0}
};

#define NO_FILE_ITEMS 7

PopupMenuRes ImageMenuRes[]={
   {"&Options",ID_IMAGE_OPTIONS,0,0}
};

#define NO_IMAGE_ITEMS 1

PopupMenuRes HelpMenuRes[]={
   {"&Contents",ID_HELP_CONTENTS,0,0}
};

#define NO_HELP_ITEMS 1

MenuRes MainMenuRes[]={
   {"&File",NO_FILE_ITEMS,FileMenuRes},
   {"&Image",NO_IMAGE_ITEMS,ImageMenuRes},
   {"&Help",NO_HELP_ITEMS,HelpMenuRes}
};

class MainMenu:public AutoMenu {
   public:
      MainMenu(Window *parent,int x,int y,int w)
         :AutoMenu(parent,MainMenuRes,3,x,y,w)
         {};

   protected:

      void CmFileOpen();
      void CmFileSave();
      void CmFileSaveAsBMP();
      void CmFileSaveAsTGA();
      void CmFileShellToDos();
      void CmFileExit();

      void CmImageCompress();
      void CmImageOptions();

      void CmHelpContents();

      DECLARE_RESPONSE_TABLE;
};

class MainMenuWindow:public Window {
   public:
      MainMenuWindow()
         :Window(NULL,NULL,0,0,ws.GetTopWindow()->GetWidth()-1,SysFont->height+FWIDTH*2+4,WA_VISABLE | WA_BORDER)
      {
         menu=new MainMenu(this,FWIDTH+2,FWIDTH+2,w-FWIDTH*2-5);
      }
      ~MainMenuWindow()
         {delete menu;}

   private:
      MainMenu *menu;
};

#endif
