//  More sophisticated demo - simulates planetary motions around a common
//  sun. Each planet is handled by a process. Written by
//  Josh Turpen (snarfy@goodnet.com) and
//  Sengan Short(sengan.short@durham.ac.uk)
//  Minor modifications by Paolo De Marino (paolodemarino@usa.net)
//
//  This file is FREEWARE - you can do whatever you want with it.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING. If not, write to the
//  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "lwp.h"
#include "lwpconio.h"
#include <dpmi.h>
#include <dos.h>
#include <stdlib.h>
#include <sys/farptr.h>
#include <time.h>
#include <go32.h>
#include <math.h>
#include <ctype.h>

#define BLOB_COUNT 50  /* 50 threads */
#define CENTERY 0.0
#define CENTERX 0.0

volatile int plot_count = 0;
void putpixel(int x, int y, char col);
void blob_proc(void *unused);
void waitVBL(void);
void getNewCoords(double *x, double *y,double *xspeed,double *yspeed,double centerx,double centery);
double gravConst = 0.0025;

int main()
{
        int i;
        char answer;
        int ids[BLOB_COUNT+1];
        __dpmi_regs regs;
        regs.x.ax = 0x13;
        __dpmi_int(0x10, &regs);
        srandom(time(0));
        lwp_init(8,RTC128);
        for(i=0;i<=BLOB_COUNT;i++)
                ids[i] = lwp_spawn(blob_proc, (void*)0, 8192,1);
        while((toupper(answer) != 'Q'))
                {
                while(!kbhit())
                        {
                        if(plot_count >= BLOB_COUNT)
                                {
                                plot_count = 0;
                                putpixel(0,0,90);
                                waitVBL();
                                }
                        lwp_yield();
                        }
                lwp_thread_disable();
                answer = toupper(getch());
                lwp_thread_enable();
                if (answer == 'U')
                        {
                        gravConst+=0.001;
                        }
                if (answer == 'D')
                        {
                        gravConst-=0.001;
                        }
                if (answer == 'N')
                        {
                        lwp_spawn(blob_proc, (void*)0,8192,1);
                        }
                }
        for(i=0;i<=BLOB_COUNT;i++)
                {
                lwp_kill(ids[i]);
                }
        regs.x.ax = 0x3;
        __dpmi_int(0x10, &regs);
        return(0);
}

void blob_proc(void *unused)
{
        double x, y, xspeed,yspeed;
        char col;

        x = (double) ((random() % 50) - 25);
        y = (double) ((random() % 30) - 15);
        col = 50;
        xspeed = (double) ((random() & 1) - 0.5);
        yspeed = (double) ((random() & 1) - 0.5);
        while(1)
                {
                putpixel((int) x,(int) y,col);
                plot_count++;
                lwp_yield();
                putpixel((int) x,(int) y,0);
                /* get new X,Y position from vector function */
                getNewCoords(&x,&y,&xspeed,&yspeed,CENTERX, CENTERY);
                }
}

void putpixel(int x, int y, char col)
{
        lwp_thread_disable();
        if(!((x < -159) || (x > 159) || (y < -99) || (y > 99)))
                {
                x+=159;
                y+=99;
  		  			 _farsetsel(_go32_conventional_mem_selector());
                _farnspokeb(0xA0000+x+y*320, col);
                }
        lwp_thread_enable();
}

void waitVBL(void)
{
        lwp_thread_disable();
        while(!(inportb(0x3DA) & 8));
        while(inportb(0x3DA) & 8);
        lwp_thread_enable();
}

void getNewCoords(double *x, double *y,double *xspeed,double *yspeed,double centerx,double centery)
{
        double tmp1, tmp2, tmp3, tmp4;
        double divisor1, divisor2;
        tmp1 = (centerx)-(*xspeed)-(*x);
        tmp2 = (centery)-(*yspeed)-(*y);
        divisor1 = sqrt((tmp1*tmp1)+(tmp2*tmp2));
        divisor2 = ((centerx-(*xspeed))*(centerx-(*xspeed)))+((centery-(*yspeed))*(centery-(*yspeed)));
        if((divisor1 != 0) && (divisor2 != 0))
                {
                tmp3 = tmp1/divisor1;
                tmp4 = tmp2/divisor1;
                (*xspeed) = ((*xspeed) + tmp3*gravConst/divisor2);
                (*yspeed) = ((*yspeed) + tmp4*gravConst/divisor2);
                (*x) += (*xspeed);
                (*y) += (*yspeed);
                }
        else
                {
                (*x) += (*xspeed);
                (*y) += (*yspeed);
                }
}
