// Associated include file : Graphics/ScrolTxt.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"

// --- TTextScroller  object

DEFINE(TTextScroller);

short RegTTextScroller;
char *IdentTTextScroller = "TTextScroller";

TTextScroller::TTextScroller()
{ Defaults();
}

TTextScroller::TTextScroller(int X, int Y, int L, int H, TLift *_Horiz, TLift *_Vert)
{ Defaults();
  Init(X,Y,L,H,_Horiz,_Vert);
}

TTextScroller::TTextScroller(TRect R, TLift *_Horiz, TLift *_Vert)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height(),_Horiz,_Vert);
}

void TTextScroller::Defaults(void)
{ // Object identification
  Register=RegTTextScroller;
  Ident=IdentTTextScroller;
  // Other default values
  TextCache=ColorCache=NULL;
  WFont=FontListing->WidthStr("W");
  HFont=FontListing->HeightStr("W");
}

void TTextScroller::Init(int X, int Y, int L, int H, TLift *_Horiz, TLift *_Vert)
{ // Herited constructions
  TScroller::Init(X,Y,L,H,100,100,_Horiz,_Vert);
  // New constructions
  SetTextSize(80,50);
}

static char Temp[100];

char *TTextScroller::GetText(int Line)
{ if (Line<=NLines)
  { sprintf(Temp,"Default text. Line n%d",Line+1);
    return Temp;
  }
  return NULL;
}

char *TTextScroller::GetColors(int )
{ return NULL;
}

void TTextScroller::SetTextSize(int _NCols, int _NLines, boolean Apply)
{ NLines=_NLines;
  NCols=_NCols;
  // Calcule la taille de la fenetre virtuelle en consquence
  WideL=NCols*WFont;
  WideH=NLines*HFont;
  // Recalcule le cache
  UpdateCache();
  // Affiche les changements
  if (Apply) SizeChanged();
}

void TTextScroller::SetCharVisible(int Col, int Line, boolean Apply)
{ int i1, i2, j1, j2;
  // Calcule les lignes, colonnes totalement visibles
  // Curieusement dans cette routine et la suivante,
  //   i=lignes et j=colonnes... ??
  i1=DecY/HFont+1;
  i2=(DecY+Where.Height()-1)/HFont;
  j1=DecX/WFont+1;
  j2=(DecX+Where.Width()-1)/WFont;
  //
  if (Col<j1)  DecX=Col*WFont;
  if (Col>j2)  DecX=(Col+1)*WFont-Where.Width();
  if (Line<i1) DecY=Line*HFont;
  if (Line>i2) DecY=(Line+1)*HFont-Where.Height();
  if (Apply) SizeChanged();
}

void TTextScroller::Draw(TRect Clip)
{ int   i,j;
  int   i1,i2;
  int   j1,j2;
  int   Y1,Y2,L,LText;
  char  C=-1;
  char *Text, *Colors;
  // Calcule les lignes, colonnes partiellement ou totalement visibles
  i1=(DecY+Clip.Y1())/HFont;
  i2=(DecY+Clip.Y2())/HFont+1;
  j1=(DecX+Clip.X1())/WFont;
  j2=(DecX+Clip.X2())/WFont+1;
  if ((j1<CacheLgn1)||(j2>CacheLgn2)) UpdateCache();
  // Trace le texte
  FontListing->BackColor(NoSysColor[0]);
  for(i=i1;i<=i2;i++)
  { Text=TextCache[i-CacheLgn1];
    if (Text!=NULL)
    { Colors=ColorCache[i-CacheLgn1];
      if (Colors==NULL) SetSysColor(LightGray);
      LText=strlen(Text);
      // Trace la ligne
      for(j=j1;j<j2;j++)
        if (j<LText)
        { if (Colors!=NULL)
          { if (Colors[j]!=C)
            { C=Colors[j];
              SetSysColor(C);
            }
          }
          PutChar(j*WFont-DecX,i*HFont-DecY,Text[j],FontListing);
        }
    }
  }
  FontListing->BackColor(NoColor);
  // Trace les fins de ligne
  SetSysColor(Black);
  for(i=i1;i<=i2;i++)
  { Text=TextCache[i-CacheLgn1];
    if (Text!=NULL) L=FontListing->WidthStr(Text)-DecX;
               else L=-DecX;
    if (L<0) L=0;
    Y1=i*HFont-DecY;
    Y2=(i+1)*HFont-DecY-1;
    if (L<Where.Width()) Bar(L,Y1,Where.Width()-1,Y2);
  }
}

void TTextScroller::UpdateCache(void)
{ int   i;
  char *T,*C;
  // Free previously allocated memory
  if (TextCache!=NULL)
  { for(i=0;i<CacheLgns;i++)
      if (TextCache[i]!=NULL) free(TextCache[i]);
    delete TextCache;
  }
  if (ColorCache!=NULL)
  { for(i=0;i<CacheLgns;i++)
      if (ColorCache[i]!=NULL) free(ColorCache[i]);
    delete ColorCache;
  }
  // Compute new cache interval
  CacheLgn1=(DecY            )/HFont;
  CacheLgn2=(DecY+Where.Height()-1)/HFont+1;
  CacheLgns=CacheLgn2-CacheLgn1+1;
  // Allocate memory and copy caching
  TextCache=new PChar[CacheLgns];
  ColorCache=new PChar[CacheLgns];
  for(i=0;i<CacheLgns;i++)
  { T=GetText(i+CacheLgn1);
    C=GetColors(i+CacheLgn1);
    if (T!=NULL)
    { TextCache[i]=strdup(T);
      if (C!=NULL)
      { ColorCache[i]=(char*)malloc(strlen(T));
        memcpy(ColorCache[i],C,strlen(T));
      }
      else ColorCache[i]=NULL;
    }
    else
    { TextCache[i]=NULL;
      ColorCache[i]=NULL;
    }
  }
}
