/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Screen graphics management
	File      : Include/Graphics/Window.H
	Author    : Eric NICOLAS
	Overview  : TWindow Object = Overlapped windows management
	UpDate    : Mar 03, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GRAPHICS_WINDOW_H_
#define _GRAPHICS_WINDOW_H_

extern short RegTWindow;
extern char *IdentTWindow;

class TWindow : public TZone
{ DECLARE(TWindow);
  protected:
    char         ColorGroup;
    TPoint       MinimalSize;
  public:
  // Public Constructors
			 TWindow();
			 TWindow(int X, int Y, int L, int H);
			 TWindow(TRect R);
  // Consctruction / Destruction
          void     Defaults();
          void     Init(int X, int Y, int L, int H);
  // Events handling
  virtual boolean  MouseLDown(TPoint Where, int Buttons);
  virtual void     HandleEvent(TEvent *Event);
  //
  virtual boolean  CanClose(void);
			 void     ComeToForeground(void);
  virtual void     CalculateClip(void);
  virtual void     GetClipRect(TRect& R);
  virtual void     Draw(TRect Clip);
  // Linked lists
          TWindow *Next();
	       TWindow *Previous();
	       TWindow *First();
	       TWindow *Last();
  virtual void     UnLink(void);
  // Objects streams
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

// Inline functions

inline TWindow *TWindow::Next()
{ return (TWindow*)(TZone::Next());
}

inline TWindow *TWindow::Previous()
{ return (TWindow*)(TZone::Previous());
}

inline TWindow *TWindow::First()
{ return (TWindow*)(TZone::First());
}

inline TWindow *TWindow::Last()
{ return (TWindow*)(TZone::Last());
}

#endif // _GRAPHICS_WINDOW_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   20/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   03/03/96 :EN: Changing color scheme so that it can be user-modified
** ------------------------------------------------------------------------*/
