/* Project SWORD
   V2.0

   SubSystem : Mathematical toolbox
   ErrorNos  : 4300..4399
   File      : Include/ToolBox/Math/Eval.H
   Author    : Eric NICOLAS
   Overview  : Math expression evaluator
   UpDate    : Dec 02, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _TOOLBOX_MATH_EVAL_H_
#define _TOOLBOX_MATH_EVAL_H_

#define erStackFull           4300
#define erStackEmpty          4301
#define erSymbolTableFull     4302
#define erSyntaxError         4303
#define erMath_DivideByZero   4304
#define erMath_ZeroPowerZero  4305
#define erMath_LogZero        4306
#define erArgNotReal          4307
#define erUnknownVariable     4308

// --- Global vars

extern char    SepDec;
extern char    SepId;

// --- Functions

void BeginEvaluate(void);
void Evaluate(char *Command);
void DoneEvaluate(void);

void SetVar(char *Nom, complex Val);
void GetVar(char *Nom, complex &Val);
void ResetVar(char *Nom, complex Val);

// --- Init/Done

void InitEval(void);
void DoneEval(void);

#endif // _TOOLBOX_MATH_EVAL_H_