/* --------------------------------------------------------------------------
   Project S.W.O.R.D
   V2.10

   SubSystem : Samples programs : Mandelbrot fractal
   File      : Samples/Mandel/ManView.CC
   Author    : Eric NICOLAS, Cedric JOULAIN
   Overview  : Mandelbrot fractal Viewer
   UpDate    : Apr 08, 1996

** Copyright (C) 1993-1996 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _SAMPLES_MANDEL_MANVIEW_H_
#define _SAMPLES_MANDEL_MANVIEW_H_

class TMandelScroller;
class TMandelImage;
class TMandelViewer;

// --- Structure

struct TZoom
{ float X1, Y1, X2, Y2;
};

// --- Global vars

extern char *IdentTMandelScroller;
extern short RegTMandelScroller;
extern char *IdentTMandelImage;
extern short RegTMandelImage;
extern char *IdentTMandelViewer;
extern short RegTMandelViewer;

// --- TMandelScroller object

// A TImageScroller (show an image with scrolling state synchronized with
// one or two scroll bars), which handle mouse clic to zoom in or zoom out
// the mandelbrot image

class TMandelScroller : public TImageScroller
{ DECLARE(TMandelScroller);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  protected:
  // --- Functions
  public:
  // Public constructors
          TMandelScroller(void);
          TMandelScroller(int X, int Y, int L, int H, TScreenBitmap *_Image,
                          TLift *HLift, TLift *VLift);
          TMandelScroller(TRect R, TScreenBitmap *_Image, TLift *HLift, TLift *VLift);
  // Construction / Destruction
          void Defaults(void);
          void Init(int X, int Y, int L, int H, TScreenBitmap *_Image,
                    TLift *HLift, TLift *VLift);
  // Message handling
          boolean  MouseLDown(TPoint Where, int Buttons);
          boolean  MouseRDown(TPoint Where, int Buttons);
};

// --- TMandelImage object

// A TScreenBitmap object which can render a mandelbrot fractal on his
// bitmap surface.

class TMandelImage : public TScreenBitmap
{ DECLARE(TMandelImage);
  // --- Datas
  protected:
    float x1, y1, x2, y2;
    float rX1, rY1, rX2, rY2;
    int   Iter;
    TZoom Zooms[50];
    int   NZooms;
  // --- Functions
  public:
  // public Constructors
          TMandelImage(void);
          TMandelImage(int Width, int Height);
  // Creation / Destruction
          void Defaults(void);
          void Init(int Width, int Height);
  // Mandelbrot fractal managment
  // :: Rendering the fractal
          void Render(void);
  // :: Zoom functions
          void SetViewport(float _x1, float _y1, float _x2, float _y2);
          void ZoomIn(int pX1, int pY1, int pX2, int pY2);
          void ZoomIn(int X, int Y);
          void ZoomOut(void);
          boolean PushZoomStatus(void);
};

// --- TMandelViewer object

// A TImageViewer that includes a TMandelScroller instead of a
// TImageScroller

class TMandelViewer : public TImageViewer
{ DECLARE(TMandelViewer);
  // --- Datas
  protected:
  // --- Functions
  public:
  // Public constructors
          TMandelViewer(void);
          TMandelViewer(int X, int Y, int L, int H, TScreenBitmap *_Image);
          TMandelViewer(TRect R, TScreenBitmap *_Image);
  // Construction / Destruction
          void     Defaults(void);
          void     Init(int X, int Y, int L, int H, TScreenBitmap *_Image);
  // Image scroller creation Hook
  virtual TImageScroller *CreateImageScroller(TRect R, TScreenBitmap *_Image, TLift *HLift, TLift *VLift);
};

#endif // _SAMPLES_MANDEL_MANVIEW_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   02/04/96 :EN: Initial draft
**   08/04/96 :EN: Adding DECLARE_EVENTS... macros
** ------------------------------------------------------------------------*/
