#! /bin/sh

#
# Adjust the paths to files used in html pages
# and rename them to DOS licit names.
#
# List must be updated.
#

cd ../doc/html-prebuilt/specification

# Map of file names that are illicit on DOS file system.
ILLICIT_NAMES_MAP=(
"coverage-bigtiff.html : cov-bigtiff.html"
)

# Create sed script to modify the file content.
rm script.sed
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  echo "/<a .* href=\".*\/${OLD_NAME}\">/s|${OLD_NAME}|${NEW_NAME}|g" >> script.sed
done

# Rename files and change their paths.
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  sed -f script.sed ${NEW_NAME} > ${NEW_NAME}.txt
  mv -vf ${NEW_NAME}.txt ${NEW_NAME}
done

# Change illicit file names in the rest of the files.
FILES=$(echo *.html ../*html)
for FILE in ${FILES}; do
  sed -f script.sed ${FILE} > ${FILE}.txt
  dtou ${FILE}.txt
  mv -vf ${FILE}.txt ${FILE}
done

rm -f script.sed script.txt fix.sed


###############################################################################


cd ../releases

# Map of file names that are illicit on DOS file system.
ILLICIT_NAMES_MAP=(
"v3.4beta007.html   : v3_4b007.html"
"v3.4beta016.html   : v3_4b016.html"
"v3.4beta018.html   : v3_4b018.html"
"v3.4beta024.html   : v3_4b024.html"
"v3.4beta028.html   : v3_4b028.html"
"v3.4beta029.html   : v3_4b029.html"
"v3.4beta031.html   : v3_4b031.html"
"v3.4beta032.html   : v3_4b032.html"
"v3.4beta033.html   : v3_4b033.html"
"v3.4beta034.html   : v3_4b034.html"
"v3.4beta035.html   : v3_4b035.html"
"v3.4beta036.html   : v3_4b036.html"
"v3.5.1.html        : v3_5_1.html"
"v3.5.2.html        : v3_5_2.html"
"v3.5.3.html        : v3_5_3.html"
"v3.5.4.html        : v3_5_4.html"
"v3.5.5.html        : v3_5_5.html"
"v3.5.6beta.html    : v3_5_6beta.html"
"v3.5.7.html        : v3_5_7.html"
"v3.6.0.html        : v3_6_0.html"
"v3.6.1.html        : v3_6_1.html"
"v3.7.0alpha.html   : v3_7_0alpha.html"
"v3.7.0beta.html    : v3_7_0beta.html"
"v3.7.0beta2.html   : v3_7_0b2.html"
"v3.7.0.html        : v3_7_0.html"
"v3.7.1.html        : v3_7_1.html"
"v3.7.2.html        : v3_7_2.html"
"v3.7.3.html        : v3_7_3.html"
"v3.7.4.html        : v3_7_4.html"
"v3.8.0.html        : v3_8_0.html"
"v3.8.1.html        : v3_8_1.html"
"v3.8.2.html        : v3_8_2.html"
"v3.9.0beta.html    : v3_9_0beta.html"
"v3.9.0.html        : v3_9_0.html"
"v3.9.1.html        : v3_9_1.html"
"v3.9.2.html        : v3_9_2.html"
"v3.9.3.html        : v3_9_3.html"
"v3.9.4.html        : v3_9_4.html"
"v3.9.5.html        : v3_9_5.html"
"v4.0.0.html        : v4_0_0.html"
"v4.0.1.html        : v4_0_1.html"
"v4.0.2.html        : v4_0_2.html"
"v4.0.3.html        : v4_0_3.html"
"v4.0.4.html        : v4_0_4.html"
"v4.0.4beta.html    : v4_0_4beta.html"
"v4.0.5.html        : v4_0_5.html"
"v4.0.6.html        : v4_0_6.html"
"v4.0.7.html        : v4_0_7.html"
"v4.0.8.html        : v4_0_8.html"
"v4.0.9.html        : v4_0_9.html"
"v4.0.10.html       : v4_0_10.html"
"v4.1.0.html        : v4_1_0.html"
"v4.2.0.html        : v4_2_0.html"
"v4.3.0.html        : v4_3_0.html"
"v4.4.0.html        : v4_4_0.html"
"v4.5.0.html        : v4_5_0.html"
)

# Create sed script to modify the file content.
rm script.sed
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  echo "/<a .* href=\".*\/${OLD_NAME}\">/s|${OLD_NAME}|${NEW_NAME}|g" >> script.sed
done

# Rename files and change their paths.
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  sed -f script.sed ${NEW_NAME} > ${NEW_NAME}.txt
  mv -vf ${NEW_NAME}.txt ${NEW_NAME}
done

# Change illicit file names in the rest of the files.
FILES=$(echo *.html ../*.html)
for FILE in ${FILES}; do
  sed -f script.sed ${FILE} > ${FILE}.txt
  dtou ${FILE}.txt
  mv -vf ${FILE}.txt ${FILE}
done

rm -f script.sed script.txt fix.sed


###############################################################################


cd ../functions

# Map of file names that are illicit on DOS file system.
ILLICIT_NAMES_MAP=(
"_TIFFauxiliary.html              : _auxiliary.html"
"_TIFFRewriteField.html           : _RewriteField.html"
"TIFFAccessTagMethods.html        : AccessTagMethods.html"
"TIFFbuffer.html                  : buffer.html"
"TIFFClientInfo.html              : ClientInfo.html"
"TIFFClose.html                   : Close.html"
"TIFFcodec.html                   : codec.html"
"TIFFcolor.html                   : color.html"
"TIFFCreateDirectory.html         : CreateDirectory.html"
"TIFFCustomDirectory.html         : CustomDirectory.html"
"TIFFCustomTagList.html           : CustomTagList.html"
"TIFFDataWidth.html               : DataWidth.html"
"TIFFDeferStrileArrayWriting.html : DeferStrileArrayWriting.html"
"TIFFError.html                   : Error.html"
"TIFFFieldDataType.html           : FldDataType.html"
"TIFFFieldName.html               : FldName.html"
"TIFFFieldPassCount.html          : FldPassCount.html"
"TIFFFieldQuery.html              : FieldQuery.html"
"TIFFFieldReadCount.html          : FldReadCount.html"
"TIFFFieldTag.html                : FldTag.html"
"TIFFFieldWriteCount.html         : FldWriteCount.html"
"TIFFFlush.html                   : Flush.html"
"TIFFGetField.html                : GetField.html"
"TIFFmemory.html                  : memory.html"
"TIFFMergeFieldInfo.html          : MergeFieldInfo.html"
"TIFFOpen.html                    : Open.html"
"TIFFOpenOptions.html             : OpenOptions.html"
"TIFFPrintDirectory.html          : PrintDirectory.html"
"TIFFProcFunctions.html           : ProcFunctions.html"
"TIFFquery.html                   : query.html"
"TIFFReadDirectory.html           : RdDirectory.html"
"TIFFReadEncodedStrip.html        : RdEncStrip.html"
"TIFFReadEncodedTile.html         : RdEncTile.html"
"TIFFReadFromUserBuffer.html      : ReadFromUserBuffer.html"
"TIFFReadRawStrip.html            : RdRawStrip.html"
"TIFFReadRawTile.html             : RdRawTile.html"
"TIFFReadRGBAImage.html           : RdRGBAImage.html"
"TIFFReadRGBAStrip.html           : RdRGBAStrip.html"
"TIFFReadRGBATile.html            : RdRGBATile.html"
"TIFFReadScanline.html            : RdScanline.html"
"TIFFReadTile.html                : RdTile.html"
"TIFFRGBAImage.html               : RGBAImage.html"
"TIFFSetDirectory.html            : SetDirectory.html"
"TIFFSetField.html                : SetField.html"
"TIFFSetTagExtender.html          : SetTagExtender.html"
"TIFFsize.html                    : size.html"
"TIFFStrileQuery.html             : StrileQuery.html"
"TIFFstrip.html                   : strip.html"
"TIFFswab.html                    : swab.html"
"TIFFtile.html                    : tile.html"
"TIFFWarning.html                 : Warning.html"
"TIFFWriteDirectory.html          : WrDirectory.html"
"TIFFWriteEncodedStrip.html       : WrEncStrip.html"
"TIFFWriteEncodedTile.html        : WrEncTile.html"
"TIFFWriteRawStrip.html           : WrRawStrip.html"
"TIFFWriteRawTile.html            : WrRawTile.html"
"TIFFWriteScanline.html           : WrScanline.html"
"TIFFWriteTile.html               : WrTile.html"
)

# Create sed script to modify the file content.
rm script.sed
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  echo "/<a .* href=\".*\/${OLD_NAME}\">/s|${OLD_NAME}|${NEW_NAME}|g" >> script.sed
done

# Rename files and change their paths.
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  sed -f script.sed ${NEW_NAME} > ${NEW_NAME}.txt
  mv -vf ${NEW_NAME}.txt ${NEW_NAME}
done


# Change illicit file names in the rest of the files.
FILES=$(echo *.html ../*.html)
for FILE in ${FILES}; do
  sed -f script.sed ${FILE} > ${FILE}.txt
  dtou ${FILE}.txt
  mv -vf ${FILE}.txt ${FILE}
done

rm -f script.sed script.txt fix.sed
