/* spyStructures.h - header to spyStructures.c
*/
#if !defined(__SPY3__) && !defined(__VPL3__) && !defined(VPL3)
#error This header was not intended for use by non-RLSystems software!
#endif
#ifndef SPY3_SPYSTRUCTURES_H
#define SPY3_SPYSTRUCTURES_H
/*****************************************************************Includes*/
#include <vpl3/spy.h>
/******************************************************************Defines*/
// messages sent to handlers
#define MSG_NONE   0x00000000
#define MSG_INIT   0x00000001
#define MSG_CANCEL 0x00000002
#define MSG_PAUSE  0x00000004
#define MSG_AID    0x00000008
#define MSG_ABORT  0x00000010
#define MSG_ALTER  0x00000020
#define MSG_HURRY  0x00000040
#define MSG_IDLE   0x00000080
// commands sent by client
// #define CMD_OP_PARAM_KIND 0x0[operativeKind]
// #define CMD_OP_PARAM_KNOW 0x1[alliances - 11-bit]
// #define CMD_OP_PARAM_FCODE 0x2[fCode]
// #define CMD_OP_PARAM_NOOP 0x3
// #define CMD_OP_MISS 0x4[missionKind]
// #define CMD_OP_MISS_NOOP 0x5
// #define CMD_OP_MISS_NOOP 0x6
// #define CMD_OP_MISS_NOOP 0x7
// #define CMD_HQ_ASIN_* 0x[8-B][0-F]
// #define CMD_HQ_ASIN_NWOP 0x8[operativeKind]
// #define CMD_HQ_ASIN_NWFU [newfunds] 0x9
// #define CMD_HQ_ASIN_CSNR [sec (oud)nr + sec (new)nr] 0xA
// #define CMD_HQ_ASIN_BOOM 0xB0 [opblazen die hap]
// #define CMD_HQ_ASIN_KILL 0xB8 [kill een operetive]
// #define CMD_PO_MISS_GOTO_* 0xC[0-F]
// #define CMD_PO_MISS_GOTO_PICKUP 0xC0
// #define CMD_PO_MISS_GOTO_FUEL   0xC8
// #define CMD_PO_MISS_GOTO_GO     0xCC
// #define CMD_PO_MISS_NOOP 0xD
// #define CMD_PO_MISS_BOOM_DAMAGE 0xE
// #define CMD_PO_MISS_BOOM_NODAM  0xF
/*******************************************************Structural defines*/
typedef struct _headQuartersType {
  short        ID;               // ID of the planet the HQ is located on
  short        masterID;         // ID of the spymaster
  long         funds;            // amount of money in reserve for spy ops
  long         budget;           // amount of money available every turn
  short        section;          // usually one: other planets with HQ facilities will have a higher number and a lower rank.
  short        operatives[100];  // operatives currently here (IDs only, always includes mater)
} headQuartersType;

typedef enum _operativeKind {
  OP_NONE       = 0, // empty record
  OP_SPY        = 1, // spy
  OP_SABOTEUR   = 2, // saboteur
  OP_COUNTER    = 3, // counter-intelligence operative
  OP_COMMANDO   = 4, // commando
  OP_HIJACKER   = 5, // ship hijacker
  OP_VOIDNAUT   = 6, // parallel universe operatives
} operativeKind;
#define numOperatives 7

typedef enum _tierKind {
  TI_NONE      = -1, // non-existant
  TI_NOVICE    =  0, // short missions - not too many of 'em. Very easy to catch, even without counter intel operatives
  TI_TRAINEE   =  1, // slightly longer missions - not to many of 'em. Relatively easy to catch, needs counter
  TI_SKILLED   =  2, // "normal" missions - "normal" amount. not so easy to catch - needs counter
  TI_COMBATANT =  3, // "normal" missions - more missions. relatively hard to catch - needs counter, can kill - but not counters as good or better than itself
  TI_WARRIOR   =  4, // "normal" missions - more missions. hard to catch - needs counter, can kill - but not counters better than itself, can turn operatives
  TI_VETERAN   =  5, // long missions - more missions. very hard to catch - needs counter, can kill, can train operatives, can turn operatives
  TI_MASTER    =  6, // very long missions - many missions. nigh impossible to catch - needs counter tier 4 or better to be caught, can and will kill anything below tier 4, can kill higher than itself, can train operatives, can turn operatives
  TI_ELITE     =  7, // very, very long missions - many, many missions - does not need debriefing but does need an occasional rest on an uninhabited world - need counter tier 6 or better, can and will kill anything below tier 6, can kill anything, can train operatives, can turn operatives
} tierKind;

typedef enum _missionKind {
  MI_IDLE       =  0,
  MI_KILL       =  1,
  MI_INFILTRATE =  2,
  MI_SABOTAGE   =  3,
  MI_COMP_VIRUS =  4,
  MI_TPL_OFF    =  5,
  MI_GTR_MAN    =  6,
  MI_HIJACK     =  7,
  MI_VOID_JUMP  =  8,
  MI_KIDNAP     =  9,
  MI_UPSET_NAT  = 10,
  MI_UPSET_COL  = 11,
  MI_ASSIMILATE = 12,
} missionKind;

typedef struct _operativeType {
  bool          (*handler)(struct _operativeType *operative, int msg, void *data);
  short         ID;                 // unique ID of the operative
  int           universeID;         // unique ID of the universe he's coming from
  short         owner;              // race that owns the operative
  operativeKind kind;               // kind of operative this record is about
  tierKind      tier;               // level of the operative
  bool          atHome;             // true if it is still in training
  long          points;             // points for the amount of info gathered by this operative & the hazard & battle skill
  short         missionDuration;    // time it's been on a mission
  short         numMissions;        // amount of missions the operative has been on
  bool          hasPod;             // true if it's ship has not been destroyed yet
  short         podID;              // ID# of the ship it owns
  bool          inPod;              // true if it is flying around
  bool          isReturning;        // true if it going home for debriefing
  short         timeSinceRest;      // amount of turns without debriefing or rest
  bool          isResting;          // true if it is resting from all it's hard work
  short         timeResting;        // amount of turns it has been laying low
  short         xCoord, yCoord;     // coordinats of the operative on the map - relevant only if not moving
  bool          inShip;             // true if in an enemy vessel
  bool          onPlanet;           // true if on the planet at the present coords
  bool          inBase;             // true if in the starbase at the present coords
  bool          inGator;            // true if in the Gator at the present coords
  long          objectID;           // ID of the object being inhabited
  bool          knownAlliances[12]; // races an operative knows he should not attack
  char          fCode[4];           // operative can't attack something with this fCode..
} operativeType;

typedef enum {
  POD_NONE   = 0, // broken - destroyed
  POD_NORMAL = 1, // operative pod
  POD_BASE   = 2, // debrief/train pod
} podKind;

typedef struct _podType {
  short         ID;             // ID of the ship
  podKind       kind;           // kind of pod
  short         owner;          // ID of the operative that owns it
  byte          fuel;           // amount of fuel on the ship (0 - 250)
  short         damage;         // should be 0 if it is to fly and not flying - also denotes whether the spy has finished building a new ship
  bool          isFlying;       // true if flying
  short         xCoord, yCoord; // coordinats of the pod on the map - relevant only if moving
  short         dX, dY;         // displacement - speed is always warp 9
  short         money;          // money on-board - stolen from enemies or taken along - used to bribe enemy troops
} podType;

typedef struct _missionType {
  bool               (*handler)(struct _missionType *mission, operativeType *operative, int msg, void *data);
  tierKind           minTier,
                     maxTier;
  operativeKind      operative[numOperatives];
} missionType;
/**************************************************************************/
#endif // SPY3_SPYSTRUCTURES_H
