dnl DO NOT EDIT THIS FILE   (misc.m4)
dnl 
dnl It has been AutoGen-ed  Sunday April 15, 2001 at 02:28:48 PM PDT
dnl From the definitions    misc.def
dnl and the template file   m4
dnl
dnl  This file defines 4 code tests
dnl
dnl AG_CHECK_ALLOCATED_CTIME

d

AC_DEFUN(AG_CHECK_ALLOCATED_CTIME,[
  AC_MSG_CHECKING([whether ctime() allocates memory for its result])
  AC_CACHE_VAL([ag_cv_allocated_ctime],[
  AC_TRY_RUN([
#include <time.h>
int main (int argc, char *argv[])
{
   time_t  timeVal = time( (time_t*)NULL );
   char*   pzTime  = ctime( &timeVal );
   free( (void*)pzTime );
   return 0;
}],[ag_cv_allocated_ctime=yes],[ag_cv_allocated_ctime=no],[ag_cv_allocated_ctime=no]
           ) # end of TRY_RUN
   for f in core*
   do
     if test -f $f && test $f -nt conftest${ac_exeext}
     then rm -f $f ; fi
   done]) # end of CACHE_VAL

 AC_MSG_RESULT([$ag_cv_allocated_ctime])
 if test x$ag_cv_allocated_ctime = xyes
 then
   AC_DEFINE(HAVE_ALLOCATED_CTIME, 1,
      [Define this if ctime() allocates memory for its result])
 fi
 ]) # end of AC_DEFUN

dnl # # # # # # # # # # # # #

dnl AG_CHECK_STRFTIME

d

AC_DEFUN(AG_CHECK_STRFTIME,[
  AC_MSG_CHECKING([whether strftime() works])
  AC_CACHE_VAL([ag_cv_strftime],[
  AC_TRY_RUN([#include <time.h>
char t_buf[ 64 ];
int main()
{
  static const char z[] = "Thursday Aug 28 240";
  struct tm tm;
  tm.tm_sec   = 36;  /* seconds after the minute [0, 61]  */
  tm.tm_min   = 44;  /* minutes after the hour [0, 59] */
  tm.tm_hour  = 12;  /* hour since midnight [0, 23] */
  tm.tm_mday  = 28;  /* day of the month [1, 31] */
  tm.tm_mon   =  7;  /* months since January [0, 11] */
  tm.tm_year  = 86;  /* years since 1900 */
  tm.tm_wday  =  4;  /* days since Sunday [0, 6] */
  tm.tm_yday  = 239; /* days since January 1 [0, 365] */
  tm.tm_isdst =  1;  /* flag for daylight savings time */
  strftime( t_buf, sizeof( t_buf ), "%A %b %d %j", &tm );
  return strcmp( t_buf, z );
}],[ag_cv_strftime=yes],[ag_cv_strftime=no],[ag_cv_strftime=no]
           ) # end of TRY_RUN
   for f in core*
   do
     if test -f $f && test $f -nt conftest${ac_exeext}
     then rm -f $f ; fi
   done]) # end of CACHE_VAL

 AC_MSG_RESULT([$ag_cv_strftime])
 if test x$ag_cv_strftime = xyes
 then
   AC_DEFINE(HAVE_STRFTIME, 1,
      [Define this if strftime() works])
 fi
 ]) # end of AC_DEFUN

dnl # # # # # # # # # # # # #

dnl AG_CHECK_POSIX_REGCOMP

d

AC_DEFUN(AG_CHECK_POSIX_REGCOMP,[
  AC_MSG_CHECKING([whether POSIX compliant regcomp()/regexec()])
  AC_CACHE_VAL([ag_cv_posix_regcomp],[
  AC_TRY_RUN([#include <sys/types.h>
#include <regex.h>
int main()
{
  regex_t  re;
  return regcomp( &re, "^.*$", REG_EXTENDED|REG_ICASE|REG_NEWLINE );
}],[ag_cv_posix_regcomp=yes],[ag_cv_posix_regcomp=no],[ag_cv_posix_regcomp=no]
           ) # end of TRY_RUN
   for f in core*
   do
     if test -f $f && test $f -nt conftest${ac_exeext}
     then rm -f $f ; fi
   done]) # end of CACHE_VAL

 AC_MSG_RESULT([$ag_cv_posix_regcomp])
 if test x$ag_cv_posix_regcomp = xyes
 then
   AC_DEFINE(HAVE_POSIX_REGCOMP, 1,
      [Define this if POSIX compliant regcomp()/regexec()])
 fi
 ]) # end of AC_DEFUN

dnl # # # # # # # # # # # # #

dnl AG_CHECK_SYS_SIGLIST

d

AC_DEFUN(AG_CHECK_SYS_SIGLIST,[
  AC_MSG_CHECKING([whether there is a global text array sys_siglist])
  AC_CACHE_VAL([ag_cv_sys_siglist],[
  AC_TRY_RUN([#include <signal.h>
int main()
{
  const char* pz = sys_siglist[1];
  return (pz != 0) ? 0 : 1;
}],[ag_cv_sys_siglist=yes],[ag_cv_sys_siglist=no],[ag_cv_sys_siglist=no]
           ) # end of TRY_RUN
   for f in core*
   do
     if test -f $f && test $f -nt conftest${ac_exeext}
     then rm -f $f ; fi
   done]) # end of CACHE_VAL

 AC_MSG_RESULT([$ag_cv_sys_siglist])
 if test x$ag_cv_sys_siglist = xyes
 then
   AC_DEFINE(HAVE_SYS_SIGLIST, 1,
      [Define this if there is a global text array sys_siglist])
 fi
 ]) # end of AC_DEFUN
