dnl  -*- Mode: M4 -*- 
dnl --------------------------------------------------------------------
dnl openmode.m4 --- 
dnl 
dnl Author:	       Gary V. Vaughan <gvaughan@oranda.demon.co.uk>
dnl Maintainer:	       Gary V. Vaughan <gvaughan@oranda.demon.co.uk>
dnl Created:	       Tue Nov 24 01:07:30 1998
dnl Last Modified:     Tue Apr 13 08:36:16 1999
dnl            by:     Bruce Korb <bkorb@gnu.org>
dnl --------------------------------------------------------------------
dnl @(#) $Id: openmode.m4,v 1.4 2000/04/04 13:22:50 bkorb Exp $
dnl --------------------------------------------------------------------
dnl 
dnl Code:

# serial 3

dnl AG_FUNC_FOPEN_BINARY
dnl Test whether fopen accepts a "b" in the mode string for binary file
dnl opening.  This makes no difference on most unices, but some OSes
dnl convert every newline written to a file to two bytes (CR LF), and
dnl every CR LF read from a file is silently converted to a newline.
dnl
AC_DEFUN(AG_FUNC_FOPEN_BINARY,
[AC_MSG_CHECKING(whether fopen accepts "b" mode)
AC_CACHE_VAL([ag_cv_func_fopen_binary],
[AC_TRY_RUN([#include <stdio.h>
int main (int argc, char *argv[])
{
   FILE *fp = fopen("/bin/sh", "rb");
   return (fclose(fp) >= 0);
}],[ag_cv_func_fopen_binary=yes],
[ag_cv_func_fopen_binary=yes],[ag_cv_func_fopen_binary=yes])
rm -f core *.exe.core])
AC_MSG_RESULT([$ag_cv_func_fopen_binary])
if test x$ag_cv_func_fopen_binary = xyes; then
  AC_DEFINE(USE_FOPEN_BINARY, 1,
	    [Define this if we can use the "b" mode for fopen safely.])
fi])

dnl AG_FUNC_FOPEN_TEXT
dnl Test whether open accepts a "t" in the mode string for text file
dnl opening.  This makes no difference on most unices, but other OSes
dnl use it to assert that every newline written to a file writes two
dnl bytes (CR LF), and every CR LF read from a file are silently
dnl converted to a newline.
dnl
AC_DEFUN(AG_FUNC_FOPEN_TEXT,
[AC_MSG_CHECKING(whether fopen accepts "t" mode)
AC_CACHE_VAL([ag_cv_func_fopen_text],
[AC_TRY_RUN([#include <stdio.h>
int main (int argc, char *argv[])
{
   FILE *fp = fopen("/bin/sh", "rt");
   return (fclose(fp) >= 0);
}],[ag_cv_func_fopen_text=yes],
[ag_cv_func_fopen_text=yes],[ag_cv_func_fopen_text=yes])
rm -f core *.exe.core])
AC_MSG_RESULT([$ag_cv_func_fopen_text])
if test x$ag_cv_func_fopen_text = xyes; then
  AC_DEFINE(USE_FOPEN_TEXT, 1,
	    [Define this if we can use the "t" mode for fopen safely.])
fi])

dnl AG_FUNC_OPEN_BINARY
dnl Test whether open accepts O_BINARY in the mode string for binary
dnl file opening.  This makes no difference on most unices, but some
dnl OSes convert every newline written to a file to two bytes (CR LF),
dnl and every CR LF read from a file is silently converted to a newline.
dnl
AC_DEFUN(AG_FUNC_OPEN_BINARY,
[AC_MSG_CHECKING(whether open accepts O_BINARY)
AC_CACHE_VAL([ag_cv_func_open_binary],
[AC_TRY_RUN([#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
int main (int argc, char *argv[])
{
   int fd = open("/bin/sh", O_RDONLY|O_BINARY);
   return (close(fd) >= 0);
}],[ag_cv_func_open_binary=yes],
[ag_cv_func_open_binary=yes],[ag_cv_func_open_binary=yes])
rm -f core *.exe.core])
AC_MSG_RESULT([$ag_cv_func_open_binary])
if test x$ag_cv_func_open_binary = xyes; then
  AC_DEFINE(HAVE_O_BINARY, 1,
	    [Define this if we can use the O_BINARY flag for open.])
fi])

dnl AG_FUNC_OPEN_TEXT
dnl Test whether open accepts O_TEXT in the mode string for text file
dnl opening.  This makes no difference on most unices, but other OSes
dnl use it to assert that every newline written to a file writes two
dnl bytes (CR LF), and every CR LF read from a file are silently
dnl converted to a newline.
dnl
AC_DEFUN(AG_FUNC_OPEN_TEXT,
[AC_MSG_CHECKING(whether open accepts O_TEXT)
AC_CACHE_VAL([ag_cv_func_open_text],
[AC_TRY_RUN([#include <stdio.h>
int main (int argc, char *argv[])
{
   int fd = open("/bin/sh", O_RDONLY|O_TEXT);
   return (close(fd) >= 0);
}],[ag_cv_func_open_text=yes],
[ag_cv_func_open_text=yes],[ag_cv_func_open_text=yes])
rm -f core *.exe.core])
AC_MSG_RESULT([$ag_cv_func_open_text])
if test x$ag_cv_func_open_text = xyes; then
  AC_DEFINE(USE_OPEN_TEXT, 1,
	    [Define this if we can use the O_TEXT flag for open.])
fi])

dnl openmode.m4 ends here
