dnl 
dnl EDIT THIS FILE WITH CAUTION  (libopts.m4)
dnl 
dnl It has been AutoGen-ed  Sunday August 11, 2002 at 10:46:06 AM PDT
dnl From the definitions    stdin
dnl and the template file   conftest.tpl
dnl
dnl @synopsis  INVOKE_LIBOPTS_MACROS
dnl
dnl  This macro will invoke the AutoConf macros specified in stdin
dnl  that have not been disabled with "omit-invocation".
dnl
AC_DEFUN([LIBOPTS_WITH_REGEX_HEADER],[
  AC_ARG_WITH([regex-header],
    AC_HELP_STRING([--with-regex-header], [a reg expr header is specified]),
    [libopts_cv_with_regex_header=${with_regex_header}],
    AC_CACHE_CHECK([whether a reg expr header is specified], libopts_cv_with_regex_header,
      libopts_cv_with_regex_header=no)
  ) # end of AC_ARG_WITH

  if test "X${libopts_cv_with_regex_header}" != Xno
  then
    AC_DEFINE_UNQUOTED([REGEX_HEADER],[<${libopts_cv_with_regex_header}>])
  else
    AC_DEFINE([REGEX_HEADER],[<regex.h>],[name of regex header file])
  fi
]) # end of AC_DEFUN of LIBOPTS_WITH_REGEX_HEADER


AC_DEFUN([LIBOPTS_WITHLIB_REGEX],[
  AC_ARG_WITH([libregex],
    AC_HELP_STRING([--with-libregex], [libregex installation prefix]),
    [libopts_cv_with_regex_root=${with_libregex}],
    AC_CACHE_CHECK([whether with-libregex was specified], libopts_cv_with_regex_root,
      libopts_cv_with_regex_root=no)
  ) # end of AC_ARG_WITH

  AC_ARG_WITH([libregex-incdir],
    AC_HELP_STRING([--with-libregex-incdir], [libregex include dir]),
    [libopts_cv_with_regex_incdir=${with_regex_incdir}],
    AC_CACHE_CHECK([whether with-libregex-incdir was specified], libopts_cv_with_regex_incdir,
      libopts_cv_with_regex_incdir=no)
  ) # end of AC_ARG_WITH

  AC_ARG_WITH([libregex-libdir],
    AC_HELP_STRING([--with-libregex-libdir], [libregex library dir]),
    [libopts_cv_with_regex_libdir=${with_regex_libdir}],
    AC_CACHE_CHECK([whether with-libregex-libdir was specified], libopts_cv_with_regex_libdir,
      libopts_cv_with_regex_libdir=no)
  ) # end of AC_ARG_WITH

  case X${libopts_cv_with_regex_incdir} in
  Xyes|Xno )
    case X${libopts_cv_with_regex_root} in
    Xyes|Xno ) libopts_cv_with_regex_incdir=no ;;
    * )        libopts_cv_with_regex_incdir=-I${libopts_cv_with_regex_root}/include ;;
    esac
  esac

  case X${libopts_cv_with_regex_libdir} in
  Xyes|Xno )
    case X${libopts_cv_with_regex_root} in
    Xyes|Xno ) libopts_cv_with_regex_libdir=no ;;
    * )        libopts_cv_with_regex_libdir="-L${libopts_cv_with_regex_root}/lib -lregex";;
    esac
  esac
  libopts_save_CPPFLAGS="${CPPFLAGS}"
  libopts_save_LDFLAGS="${LDFLAGS}"

  case X${libopts_cv_with_regex_incdir} in
  Xyes|Xno ) ;;
  * ) CPPFLAGS="${CPPFLAGS} ${libopts_cv_with_regex_incdir}" ;;
  esac

  case X${libopts_cv_with_regex_libdir} in
  Xyes|Xno ) ;;
  * )
    LDFLAGS="${LDFLAGS} ${libopts_cv_with_regex_libdir}" ;;
  esac
  AC_MSG_CHECKING([whether libregex functions properly])
  AC_CACHE_VAL([libopts_cv_with_regex],[
  AC_TRY_RUN([@%:@include <stdio.h>
@%:@include <sys/types.h>
@%:@include REGEX_HEADER
static regex_t re;
void comp_re( const char* pzPat ) {
  int res = regcomp( &re, pzPat, REG_EXTENDED|REG_ICASE|REG_NEWLINE );
  if (res == 0) return;
  exit( res ); }
int main() {
  int  res;
  regmatch_t m@<:@2@:>@;
  comp_re( "^.*\@S|@"   );
  comp_re( "()|no.*" );
  comp_re( "."       );
  if (regexec( &re, "X", 2, m, 0 ) != 0)  return 1;
  if ((m@<:@0@:>@.rm_so != 0) || (m@<:@0@:>@.rm_eo != 1)) {
    fputs( "error: regex -->.<-- did not match\n", stderr );
    return 1;
  }
  return 0; }],
    [libopts_cv_with_regex=yes],[libopts_cv_with_regex=no],[libopts_cv_with_regex=no]
  ) # end of AC_TRY_RUN ]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${libopts_cv_with_regex}])

  if test "X${libopts_cv_with_regex}" = Xno
  then
    CPPFLAGS="${libopts_save_CPPFLAGS}"
    LDFLAGS="${libopts_save_LDFLAGS}"
        	cat >&2 <<'_EOF_'
I cannot detect POSIX compliant regcomp/regexec routines.
These are required for AutoGen to work correctly.  If you have
such a library present on your system, you must specify it by
setting the LIBS environment variable, e.g., "LIBS='-lregex'".
If you do not have such a library on your system, then you should
download and install, for example, the one from:
    ftp://ftp.gnu.org/gnu/rx/
_EOF_
AC_MSG_ERROR([Cannot find working POSIX regex library])
  fi
]) # end of AC_DEFUN of LIBOPTS_WITHLIB_REGEX


AC_DEFUN([LIBOPTS_RUN_ALLOCATED_CTIME],[
  AC_MSG_CHECKING([whether ctime() allocates memory for its result])
  AC_CACHE_VAL([libopts_cv_run_allocated_ctime],[
  AC_TRY_RUN([@%:@include <time.h>
int main (int argc, char** argv) {
   time_t  timeVal = time( (time_t*)NULL );
   char*   pzTime  = ctime( &timeVal );
   free( (void*)pzTime );
   return 0; }],
    [libopts_cv_run_allocated_ctime=yes],[libopts_cv_run_allocated_ctime=no],[libopts_cv_run_allocated_ctime=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${libopts_cv_run_allocated_ctime}])

  if test "X${libopts_cv_run_allocated_ctime}" != Xno
  then
    AC_DEFINE([HAVE_ALLOCATED_CTIME],[1],
        [Define this if ctime() allocates memory for its result])
  fi
]) # end of AC_DEFUN of LIBOPTS_RUN_ALLOCATED_CTIME


AC_DEFUN([LIBOPTS_RUN_PATHFIND],[
  AC_MSG_CHECKING([whether pathfind(3) works])
  AC_CACHE_VAL([libopts_cv_run_pathfind],[
  AC_TRY_RUN([@%:@include <string.h>
@%:@include <stdlib.h>
int main (int argc, char** argv) {
   char* pz = pathfind( getenv( "PATH" ), "sh", "x" );
   return (pz == 0) ? 1 : 0;
}],
    [libopts_cv_run_pathfind=yes],[libopts_cv_run_pathfind=no],[libopts_cv_run_pathfind=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${libopts_cv_run_pathfind}])

  if test "X${libopts_cv_run_pathfind}" != Xno
  then
    AC_DEFINE([HAVE_PATHFIND],[1],
        [Define this if pathfind(3) works])
  fi
]) # end of AC_DEFUN of LIBOPTS_RUN_PATHFIND


AC_DEFUN([LIBOPTS_RUN_STRFTIME],[
  AC_MSG_CHECKING([whether strftime() works])
  AC_CACHE_VAL([libopts_cv_run_strftime],[
  AC_TRY_RUN([@%:@include <time.h>
@%:@include <string.h>
char t_buf@<:@ 64 @:>@;
int main() {
  static const char z@<:@@:>@ = "Thursday Aug 28 240";
  struct tm tm;
  tm.tm_sec   = 36;  /* seconds after the minute @<:@0, 61@:>@  */
  tm.tm_min   = 44;  /* minutes after the hour @<:@0, 59@:>@ */
  tm.tm_hour  = 12;  /* hour since midnight @<:@0, 23@:>@ */
  tm.tm_mday  = 28;  /* day of the month @<:@1, 31@:>@ */
  tm.tm_mon   =  7;  /* months since January @<:@0, 11@:>@ */
  tm.tm_year  = 86;  /* years since 1900 */
  tm.tm_wday  =  4;  /* days since Sunday @<:@0, 6@:>@ */
  tm.tm_yday  = 239; /* days since January 1 @<:@0, 365@:>@ */
  tm.tm_isdst =  1;  /* flag for daylight savings time */
  strftime( t_buf, sizeof( t_buf ), "%A %b %d %j", &tm );
  return (strcmp( t_buf, z ) != 0); }],
    [libopts_cv_run_strftime=yes],[libopts_cv_run_strftime=no],[libopts_cv_run_strftime=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${libopts_cv_run_strftime}])

  if test "X${libopts_cv_run_strftime}" != Xno
  then
    AC_DEFINE([HAVE_STRFTIME],[1],
        [Define this if strftime() works])
  fi
]) # end of AC_DEFUN of LIBOPTS_RUN_STRFTIME


AC_DEFUN([LIBOPTS_RUN_FOPEN_BINARY],[
  AC_MSG_CHECKING([whether fopen accepts "b" mode])
  AC_CACHE_VAL([libopts_cv_run_fopen_binary],[
  AC_TRY_RUN([@%:@include <stdio.h>
int main (int argc, char** argv) {
FILE* fp = fopen("conftest.@S|@ac_ext", "rb");
return (fp == NULL) ? 1 : fclose(fp); }],
    [libopts_cv_run_fopen_binary=yes],[libopts_cv_run_fopen_binary=no],[libopts_cv_run_fopen_binary=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${libopts_cv_run_fopen_binary}])

  if test "X${libopts_cv_run_fopen_binary}" != Xno
  then
    AC_DEFINE([FOPEN_BINARY_FLAG],"b",
	[fopen(3) accepts a 'b' in the mode flag])
  else
    AC_DEFINE([FOPEN_BINARY_FLAG],"",
	[fopen(3) accepts a 'b' in the mode flag])
  fi
]) # end of AC_DEFUN of LIBOPTS_RUN_FOPEN_BINARY


AC_DEFUN([LIBOPTS_RUN_FOPEN_TEXT],[
  AC_MSG_CHECKING([whether fopen accepts "t" mode])
  AC_CACHE_VAL([libopts_cv_run_fopen_text],[
  AC_TRY_RUN([@%:@include <stdio.h>
int main (int argc, char** argv) {
FILE* fp = fopen("conftest.@S|@ac_ext", "rt");
return (fp == NULL) ? 1 : fclose(fp); }],
    [libopts_cv_run_fopen_text=yes],[libopts_cv_run_fopen_text=no],[libopts_cv_run_fopen_text=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${libopts_cv_run_fopen_text}])

  if test "X${libopts_cv_run_fopen_text}" != Xno
  then
    AC_DEFINE([FOPEN_TEXT_FLAG],"t",
	[fopen(3) accepts a 't' in the mode flag])
  else
    AC_DEFINE([FOPEN_TEXT_FLAG],"",
	[fopen(3) accepts a 't' in the mode flag])
  fi
]) # end of AC_DEFUN of LIBOPTS_RUN_FOPEN_TEXT


AC_DEFUN([INVOKE_LIBOPTS_MACROS],[
  # Check to see if a reg expr header is specified.
  LIBOPTS_WITH_REGEX_HEADER

  # Check to see if a working libregex can be found.
  LIBOPTS_WITHLIB_REGEX

  # Check to see if ctime() allocates memory for its result.
  LIBOPTS_RUN_ALLOCATED_CTIME

  # Check to see if pathfind(3) works.
  LIBOPTS_RUN_PATHFIND

  # Check to see if strftime() works.
  LIBOPTS_RUN_STRFTIME

  # Check to see if fopen accepts "b" mode.
  LIBOPTS_RUN_FOPEN_BINARY

  # Check to see if fopen accepts "t" mode.
  LIBOPTS_RUN_FOPEN_TEXT
  
]) # end AC_DEFUN of INVOKE_LIBOPTS_MACROS

dnl @synopsis  AUTOOPTS_CHECK
dnl
dnl If autoopts-config works, add the linking information to
dnl LIBS.  Otherwise, configure the LIBOPTS_DIR subdirectory
dnl and run all the config tests that library needs.
dnl
AC_DEFUN([AUTOOPTS_CHECK],[
  AC_MSG_CHECKING([whether autoopts-config can be found])
  AC_CACHE_VAL([lo_cv_test_autoopts],[
    lo_cv_test_autoopts=`autoopts-config --libs` 2> /dev/null
    if [ $? -ne 0 ]
    then lo_cv_test_autoopts=no
    else if [ -z "$lo_cv_test_autoopts" ]
         then lo_cv_test_autoopts=yes
    fi ; fi
  ]) # end of CACHE_VAL
  AC_MSG_RESULT([${lo_cv_test_autoopts}])

  if test "X${lo_cv_test_autoopts}" != Xno
  then
    LIBS="${LIBS} ${lo_cv_test_autoopts}"
  else
    INVOKE_LIBOPTS_MACROS
    LIBOPTS_DIR=libopts-18.0.9
    AC_SUBST( LIBOPTS_DIR )
  fi
]) # end of AC_DEFUN of AUTOOPTS_CHECK
