/*
  File autogenerated by gengetopt version 2.14
  generated with the following command:
  /home/bettini/usr/local/bin/gengetopt --input cmdline.ggo --unamed-opts --no-handle-help --no-handle-version 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);


char *cmdline_parser_gen_references_values[] = {"inline", "postline", "postdoc", 0} ;	/* Possible values for gen-references.  */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->input_given = 0 ;
  args_info->output_given = 0 ;
  args_info->src_lang_given = 0 ;
  args_info->lang_list_given = 0 ;
  args_info->outlang_list_given = 0 ;
  args_info->out_format_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->doc_given = 0 ;
  args_info->no_doc_given = 0 ;
  args_info->css_given = 0 ;
  args_info->title_given = 0 ;
  args_info->tab_given = 0 ;
  args_info->header_given = 0 ;
  args_info->footer_given = 0 ;
  args_info->style_file_given = 0 ;
  args_info->outlang_def_given = 0 ;
  args_info->outlang_map_given = 0 ;
  args_info->data_dir_given = 0 ;
  args_info->output_dir_given = 0 ;
  args_info->lang_def_given = 0 ;
  args_info->lang_map_given = 0 ;
  args_info->line_number_given = 0 ;
  args_info->line_number_ref_given = 0 ;
  args_info->gen_references_given = 0 ;
  args_info->ctags_file_given = 0 ;
  args_info->ctags_given = 0 ;
  args_info->gen_version_given = 0 ;
  args_info->check_lang_given = 0 ;
  args_info->check_outlang_given = 0 ;
  args_info->failsafe_given = 0 ;
  args_info->debug_langdef_given = 0 ;
  args_info->show_regex_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->input_arg = NULL;
  args_info->input_orig = NULL;
  args_info->output_arg = NULL;
  args_info->output_orig = NULL;
  args_info->src_lang_arg = NULL;
  args_info->src_lang_orig = NULL;
  args_info->out_format_arg = gengetopt_strdup ("html");
  args_info->out_format_orig = NULL;
  args_info->css_arg = NULL;
  args_info->css_orig = NULL;
  args_info->title_arg = NULL;
  args_info->title_orig = NULL;
  args_info->tab_arg = 8;
  args_info->tab_orig = NULL;
  args_info->header_arg = NULL;
  args_info->header_orig = NULL;
  args_info->footer_arg = NULL;
  args_info->footer_orig = NULL;
  args_info->style_file_arg = gengetopt_strdup ("default.style");
  args_info->style_file_orig = NULL;
  args_info->outlang_def_arg = NULL;
  args_info->outlang_def_orig = NULL;
  args_info->outlang_map_arg = gengetopt_strdup ("outlang.map");
  args_info->outlang_map_orig = NULL;
  args_info->data_dir_arg = NULL;
  args_info->data_dir_orig = NULL;
  args_info->output_dir_arg = NULL;
  args_info->output_dir_orig = NULL;
  args_info->lang_def_arg = NULL;
  args_info->lang_def_orig = NULL;
  args_info->lang_map_arg = gengetopt_strdup ("lang.map");
  args_info->lang_map_orig = NULL;
  args_info->line_number_ref_arg = gengetopt_strdup ("line");
  args_info->line_number_ref_orig = NULL;
  args_info->gen_references_arg = gengetopt_strdup ("inline");
  args_info->gen_references_orig = NULL;
  args_info->ctags_file_arg = gengetopt_strdup ("tags");
  args_info->ctags_file_orig = NULL;
  args_info->ctags_arg = gengetopt_strdup ("ctags --excmd=n --tag-relative=yes");
  args_info->ctags_orig = NULL;
  args_info->gen_version_flag = 1;
  args_info->check_lang_arg = NULL;
  args_info->check_lang_orig = NULL;
  args_info->check_outlang_arg = NULL;
  args_info->check_outlang_orig = NULL;
  args_info->show_regex_arg = NULL;
  args_info->show_regex_orig = NULL;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n%s\n", "Highlight the syntax of a source file (e.g. Java) into a specific format (e.g. \nHTML)");
  printf("\nUsage: %s [OPTIONS]... [FILES]...\n\n", CMDLINE_PARSER_PACKAGE);
  printf("%s\n","  -h, --help                    Print help and exit");
  printf("%s\n","  -V, --version                 Print version and exit");
  printf("%s\n","  -i, --input=filename          input file. default std input");
  printf("%s\n","  -o, --output=filename         output file. default std output. If STDOUT is \n                                  specified, the output is directed to standard \n                                  output");
  printf("%s\n","  -s, --src-lang=STRING         source language (use --lang-list to get the \n                                  complete list).  If not specified, the source \n                                  language will be guessed from the file \n                                  extension.");
  printf("%s\n","      --lang-list               list all the supported language and associated \n                                  language definition file");
  printf("%s\n","      --outlang-list            list all the supported output language and \n                                  associated language definition file");
  printf("%s\n","  -f, --out-format=STRING       output format (use --outlang-list to get the \n                                  complete list)  (default=`html')");
  printf("%s\n","  -v, --verbose                 verbose mode on");
  printf("%s\n","  -d, --doc                     create an output file that can be used as a \n                                  stand alone document (e.g., not to be \n                                  included in another one)");
  printf("%s\n","      --no-doc                  cancel the --doc option even if it is implied \n                                  (e.g., when css is given)");
  printf("%s\n","  -c, --css=filename            the external style sheet filename.  Implies \n                                  --doc");
  printf("%s\n","  -T, --title=STRING            give a title to the output document.  Implies \n                                  --doc");
  printf("%s\n","  -t, --tab=INT                 specify tab length.  (default=`8')");
  printf("%s\n","  -H, --header=filename         file to insert as header");
  printf("%s\n","  -F, --footer=filename         file to insert as footer");
  printf("%s\n","      --style-file=filename     specify the file containing format options  \n                                  (default=`default.style')");
  printf("%s\n","      --outlang-def=filename    output language definition file");
  printf("%s\n","      --outlang-map=filename    output language map file  \n                                  (default=`outlang.map')");
  printf("%s\n","      --data-dir=path           directory where language definition files and \n                                  language maps are searched for.  If not \n                                  specified these files are searched for in the \n                                  current directory and in the data dir \n                                  installation directory");
  printf("%s\n","      --output-dir=path         output directory");
  printf("%s\n","      --lang-def=filename       language definition file");
  printf("%s\n","      --lang-map=filename       language map file  (default=`lang.map')");
  printf("%s\n","\nreference generation:");
  printf("%s\n","  -n, --line-number             number all output lines");
  printf("%s\n","      --line-number-ref[=prefix]\n                                number all output lines and generate an anchor, \n                                  made of the specified prefix + the line \n                                  number  (default=`line')");
  printf("%s\n","      --gen-references=STRING   generate references  (possible \n                                  values=\"inline\", \"postline\", \"postdoc\" \n                                  default=`inline')");
  printf("%s\n","      --ctags-file=filename     specify the file generated by ctags that will \n                                  be used to generate references  \n                                  (default=`tags')");
  printf("%s\n","      --ctags=cmd               how to run the ctags command.  If this option \n                                  is not specified, ctags will be executed with \n                                  the default value.  If it is specified with \n                                  an empty string, ctags will not be executed \n                                  at all  (default=`ctags --excmd=n \n                                  --tag-relative=yes')");
  printf("%s\n","\ntesting:");
  printf("%s\n","      --gen-version             put source-highlight version in the generated \n                                  file  (default=on)");
  printf("%s\n","      --check-lang=filename     only check the correctness of a language \n                                  definition file");
  printf("%s\n","      --check-outlang=filename  only check the correctness of an output \n                                  language definition file");
  printf("%s\n","      --failsafe                if no language definition is found for the \n                                  input, it is simply copied to the output");
  printf("%s\n","      --debug-langdef           debug a language definition");
  printf("%s\n","      --show-regex=filename     show the regular expression automaton \n                                  corresponding to a language definition file");
  
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  
  unsigned int i;
  if (args_info->input_arg)
    {
      free (args_info->input_arg); /* free previous argument */
      args_info->input_arg = 0;
    }
  if (args_info->input_orig)
    {
      free (args_info->input_orig); /* free previous argument */
      args_info->input_orig = 0;
    }
  if (args_info->output_arg)
    {
      free (args_info->output_arg); /* free previous argument */
      args_info->output_arg = 0;
    }
  if (args_info->output_orig)
    {
      free (args_info->output_orig); /* free previous argument */
      args_info->output_orig = 0;
    }
  if (args_info->src_lang_arg)
    {
      free (args_info->src_lang_arg); /* free previous argument */
      args_info->src_lang_arg = 0;
    }
  if (args_info->src_lang_orig)
    {
      free (args_info->src_lang_orig); /* free previous argument */
      args_info->src_lang_orig = 0;
    }
  if (args_info->out_format_arg)
    {
      free (args_info->out_format_arg); /* free previous argument */
      args_info->out_format_arg = 0;
    }
  if (args_info->out_format_orig)
    {
      free (args_info->out_format_orig); /* free previous argument */
      args_info->out_format_orig = 0;
    }
  if (args_info->css_arg)
    {
      free (args_info->css_arg); /* free previous argument */
      args_info->css_arg = 0;
    }
  if (args_info->css_orig)
    {
      free (args_info->css_orig); /* free previous argument */
      args_info->css_orig = 0;
    }
  if (args_info->title_arg)
    {
      free (args_info->title_arg); /* free previous argument */
      args_info->title_arg = 0;
    }
  if (args_info->title_orig)
    {
      free (args_info->title_orig); /* free previous argument */
      args_info->title_orig = 0;
    }
  if (args_info->tab_orig)
    {
      free (args_info->tab_orig); /* free previous argument */
      args_info->tab_orig = 0;
    }
  if (args_info->header_arg)
    {
      free (args_info->header_arg); /* free previous argument */
      args_info->header_arg = 0;
    }
  if (args_info->header_orig)
    {
      free (args_info->header_orig); /* free previous argument */
      args_info->header_orig = 0;
    }
  if (args_info->footer_arg)
    {
      free (args_info->footer_arg); /* free previous argument */
      args_info->footer_arg = 0;
    }
  if (args_info->footer_orig)
    {
      free (args_info->footer_orig); /* free previous argument */
      args_info->footer_orig = 0;
    }
  if (args_info->style_file_arg)
    {
      free (args_info->style_file_arg); /* free previous argument */
      args_info->style_file_arg = 0;
    }
  if (args_info->style_file_orig)
    {
      free (args_info->style_file_orig); /* free previous argument */
      args_info->style_file_orig = 0;
    }
  if (args_info->outlang_def_arg)
    {
      free (args_info->outlang_def_arg); /* free previous argument */
      args_info->outlang_def_arg = 0;
    }
  if (args_info->outlang_def_orig)
    {
      free (args_info->outlang_def_orig); /* free previous argument */
      args_info->outlang_def_orig = 0;
    }
  if (args_info->outlang_map_arg)
    {
      free (args_info->outlang_map_arg); /* free previous argument */
      args_info->outlang_map_arg = 0;
    }
  if (args_info->outlang_map_orig)
    {
      free (args_info->outlang_map_orig); /* free previous argument */
      args_info->outlang_map_orig = 0;
    }
  if (args_info->data_dir_arg)
    {
      free (args_info->data_dir_arg); /* free previous argument */
      args_info->data_dir_arg = 0;
    }
  if (args_info->data_dir_orig)
    {
      free (args_info->data_dir_orig); /* free previous argument */
      args_info->data_dir_orig = 0;
    }
  if (args_info->output_dir_arg)
    {
      free (args_info->output_dir_arg); /* free previous argument */
      args_info->output_dir_arg = 0;
    }
  if (args_info->output_dir_orig)
    {
      free (args_info->output_dir_orig); /* free previous argument */
      args_info->output_dir_orig = 0;
    }
  if (args_info->lang_def_arg)
    {
      free (args_info->lang_def_arg); /* free previous argument */
      args_info->lang_def_arg = 0;
    }
  if (args_info->lang_def_orig)
    {
      free (args_info->lang_def_orig); /* free previous argument */
      args_info->lang_def_orig = 0;
    }
  if (args_info->lang_map_arg)
    {
      free (args_info->lang_map_arg); /* free previous argument */
      args_info->lang_map_arg = 0;
    }
  if (args_info->lang_map_orig)
    {
      free (args_info->lang_map_orig); /* free previous argument */
      args_info->lang_map_orig = 0;
    }
  if (args_info->line_number_ref_arg)
    {
      free (args_info->line_number_ref_arg); /* free previous argument */
      args_info->line_number_ref_arg = 0;
    }
  if (args_info->line_number_ref_orig)
    {
      free (args_info->line_number_ref_orig); /* free previous argument */
      args_info->line_number_ref_orig = 0;
    }
  if (args_info->gen_references_arg)
    {
      free (args_info->gen_references_arg); /* free previous argument */
      args_info->gen_references_arg = 0;
    }
  if (args_info->gen_references_orig)
    {
      free (args_info->gen_references_orig); /* free previous argument */
      args_info->gen_references_orig = 0;
    }
  if (args_info->ctags_file_arg)
    {
      free (args_info->ctags_file_arg); /* free previous argument */
      args_info->ctags_file_arg = 0;
    }
  if (args_info->ctags_file_orig)
    {
      free (args_info->ctags_file_orig); /* free previous argument */
      args_info->ctags_file_orig = 0;
    }
  if (args_info->ctags_arg)
    {
      free (args_info->ctags_arg); /* free previous argument */
      args_info->ctags_arg = 0;
    }
  if (args_info->ctags_orig)
    {
      free (args_info->ctags_orig); /* free previous argument */
      args_info->ctags_orig = 0;
    }
  if (args_info->check_lang_arg)
    {
      free (args_info->check_lang_arg); /* free previous argument */
      args_info->check_lang_arg = 0;
    }
  if (args_info->check_lang_orig)
    {
      free (args_info->check_lang_orig); /* free previous argument */
      args_info->check_lang_orig = 0;
    }
  if (args_info->check_outlang_arg)
    {
      free (args_info->check_outlang_arg); /* free previous argument */
      args_info->check_outlang_arg = 0;
    }
  if (args_info->check_outlang_orig)
    {
      free (args_info->check_outlang_orig); /* free previous argument */
      args_info->check_outlang_orig = 0;
    }
  if (args_info->show_regex_arg)
    {
      free (args_info->show_regex_arg); /* free previous argument */
      args_info->show_regex_arg = 0;
    }
  if (args_info->show_regex_orig)
    {
      free (args_info->show_regex_orig); /* free previous argument */
      args_info->show_regex_orig = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  if (args_info->help_given) {
    fprintf(outfile, "%s\n", "help");
  }
  if (args_info->version_given) {
    fprintf(outfile, "%s\n", "version");
  }
  if (args_info->input_given) {
    if (args_info->input_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "input", args_info->input_orig);
    } else {
      fprintf(outfile, "%s\n", "input");
    }
  }
  if (args_info->output_given) {
    if (args_info->output_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "output", args_info->output_orig);
    } else {
      fprintf(outfile, "%s\n", "output");
    }
  }
  if (args_info->src_lang_given) {
    if (args_info->src_lang_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "src-lang", args_info->src_lang_orig);
    } else {
      fprintf(outfile, "%s\n", "src-lang");
    }
  }
  if (args_info->lang_list_given) {
    fprintf(outfile, "%s\n", "lang-list");
  }
  if (args_info->outlang_list_given) {
    fprintf(outfile, "%s\n", "outlang-list");
  }
  if (args_info->out_format_given) {
    if (args_info->out_format_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "out-format", args_info->out_format_orig);
    } else {
      fprintf(outfile, "%s\n", "out-format");
    }
  }
  if (args_info->verbose_given) {
    fprintf(outfile, "%s\n", "verbose");
  }
  if (args_info->doc_given) {
    fprintf(outfile, "%s\n", "doc");
  }
  if (args_info->no_doc_given) {
    fprintf(outfile, "%s\n", "no-doc");
  }
  if (args_info->css_given) {
    if (args_info->css_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "css", args_info->css_orig);
    } else {
      fprintf(outfile, "%s\n", "css");
    }
  }
  if (args_info->title_given) {
    if (args_info->title_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "title", args_info->title_orig);
    } else {
      fprintf(outfile, "%s\n", "title");
    }
  }
  if (args_info->tab_given) {
    if (args_info->tab_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "tab", args_info->tab_orig);
    } else {
      fprintf(outfile, "%s\n", "tab");
    }
  }
  if (args_info->header_given) {
    if (args_info->header_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "header", args_info->header_orig);
    } else {
      fprintf(outfile, "%s\n", "header");
    }
  }
  if (args_info->footer_given) {
    if (args_info->footer_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "footer", args_info->footer_orig);
    } else {
      fprintf(outfile, "%s\n", "footer");
    }
  }
  if (args_info->style_file_given) {
    if (args_info->style_file_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "style-file", args_info->style_file_orig);
    } else {
      fprintf(outfile, "%s\n", "style-file");
    }
  }
  if (args_info->outlang_def_given) {
    if (args_info->outlang_def_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "outlang-def", args_info->outlang_def_orig);
    } else {
      fprintf(outfile, "%s\n", "outlang-def");
    }
  }
  if (args_info->outlang_map_given) {
    if (args_info->outlang_map_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "outlang-map", args_info->outlang_map_orig);
    } else {
      fprintf(outfile, "%s\n", "outlang-map");
    }
  }
  if (args_info->data_dir_given) {
    if (args_info->data_dir_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "data-dir", args_info->data_dir_orig);
    } else {
      fprintf(outfile, "%s\n", "data-dir");
    }
  }
  if (args_info->output_dir_given) {
    if (args_info->output_dir_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "output-dir", args_info->output_dir_orig);
    } else {
      fprintf(outfile, "%s\n", "output-dir");
    }
  }
  if (args_info->lang_def_given) {
    if (args_info->lang_def_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "lang-def", args_info->lang_def_orig);
    } else {
      fprintf(outfile, "%s\n", "lang-def");
    }
  }
  if (args_info->lang_map_given) {
    if (args_info->lang_map_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "lang-map", args_info->lang_map_orig);
    } else {
      fprintf(outfile, "%s\n", "lang-map");
    }
  }
  if (args_info->line_number_given) {
    fprintf(outfile, "%s\n", "line-number");
  }
  if (args_info->line_number_ref_given) {
    if (args_info->line_number_ref_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "line-number-ref", args_info->line_number_ref_orig);
    } else {
      fprintf(outfile, "%s\n", "line-number-ref");
    }
  }
  if (args_info->gen_references_given) {
    if (args_info->gen_references_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "gen-references", args_info->gen_references_orig);
    } else {
      fprintf(outfile, "%s\n", "gen-references");
    }
  }
  if (args_info->ctags_file_given) {
    if (args_info->ctags_file_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "ctags-file", args_info->ctags_file_orig);
    } else {
      fprintf(outfile, "%s\n", "ctags-file");
    }
  }
  if (args_info->ctags_given) {
    if (args_info->ctags_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "ctags", args_info->ctags_orig);
    } else {
      fprintf(outfile, "%s\n", "ctags");
    }
  }
  if (args_info->gen_version_given) {
    fprintf(outfile, "%s\n", "gen-version");
  }
  if (args_info->check_lang_given) {
    if (args_info->check_lang_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "check-lang", args_info->check_lang_orig);
    } else {
      fprintf(outfile, "%s\n", "check-lang");
    }
  }
  if (args_info->check_outlang_given) {
    if (args_info->check_outlang_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "check-outlang", args_info->check_outlang_orig);
    } else {
      fprintf(outfile, "%s\n", "check-outlang");
    }
  }
  if (args_info->failsafe_given) {
    fprintf(outfile, "%s\n", "failsafe");
  }
  if (args_info->debug_langdef_given) {
    fprintf(outfile, "%s\n", "debug-langdef");
  }
  if (args_info->show_regex_given) {
    if (args_info->show_regex_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "show-regex", args_info->show_regex_orig);
    } else {
      fprintf(outfile, "%s\n", "show-regex");
    }
  }
  
  fclose (outfile);

  i = EXIT_SUCCESS;
  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

static int
check_possible_values(const char *val, char *values[])
{
  int i, found;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return 0; /* NULL means no argument for the option */

  for (found = i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          found++;
          if (strlen(values[i]) == len)
            return 1; /* exact macth no need to check more */
        }
    }

  return found; /* return how many values are matched */
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int found = 0;
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "input",	1, NULL, 'i' },
        { "output",	1, NULL, 'o' },
        { "src-lang",	1, NULL, 's' },
        { "lang-list",	0, NULL, 0 },
        { "outlang-list",	0, NULL, 0 },
        { "out-format",	1, NULL, 'f' },
        { "verbose",	0, NULL, 'v' },
        { "doc",	0, NULL, 'd' },
        { "no-doc",	0, NULL, 0 },
        { "css",	1, NULL, 'c' },
        { "title",	1, NULL, 'T' },
        { "tab",	1, NULL, 't' },
        { "header",	1, NULL, 'H' },
        { "footer",	1, NULL, 'F' },
        { "style-file",	1, NULL, 0 },
        { "outlang-def",	1, NULL, 0 },
        { "outlang-map",	1, NULL, 0 },
        { "data-dir",	1, NULL, 0 },
        { "output-dir",	1, NULL, 0 },
        { "lang-def",	1, NULL, 0 },
        { "lang-map",	1, NULL, 0 },
        { "line-number",	0, NULL, 'n' },
        { "line-number-ref",	2, NULL, 0 },
        { "gen-references",	1, NULL, 0 },
        { "ctags-file",	1, NULL, 0 },
        { "ctags",	1, NULL, 0 },
        { "gen-version",	0, NULL, 0 },
        { "check-lang",	1, NULL, 0 },
        { "check-outlang",	1, NULL, 0 },
        { "failsafe",	0, NULL, 0 },
        { "debug-langdef",	0, NULL, 0 },
        { "show-regex",	1, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVi:o:s:f:vdc:T:t:H:F:n", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (local_args_info.help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->help_given && ! override)
            continue;
          local_args_info.help_given = 1;
          args_info->help_given = 1;
          cmdline_parser_free (&local_args_info);
          return 0;

        case 'V':	/* Print version and exit.  */
          if (local_args_info.version_given)
            {
              fprintf (stderr, "%s: `--version' (`-V') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->version_given && ! override)
            continue;
          local_args_info.version_given = 1;
          args_info->version_given = 1;
          cmdline_parser_free (&local_args_info);
          return 0;

        case 'i':	/* input file. default std input.  */
          if (local_args_info.input_given)
            {
              fprintf (stderr, "%s: `--input' (`-i') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->input_given && ! override)
            continue;
          local_args_info.input_given = 1;
          args_info->input_given = 1;
          if (args_info->input_arg)
            free (args_info->input_arg); /* free previous string */
          args_info->input_arg = gengetopt_strdup (optarg);
          if (args_info->input_orig)
            free (args_info->input_orig); /* free previous string */
          args_info->input_orig = gengetopt_strdup (optarg);
          break;

        case 'o':	/* output file. default std output. If STDOUT is specified, the output is directed to standard output.  */
          if (local_args_info.output_given)
            {
              fprintf (stderr, "%s: `--output' (`-o') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->output_given && ! override)
            continue;
          local_args_info.output_given = 1;
          args_info->output_given = 1;
          if (args_info->output_arg)
            free (args_info->output_arg); /* free previous string */
          args_info->output_arg = gengetopt_strdup (optarg);
          if (args_info->output_orig)
            free (args_info->output_orig); /* free previous string */
          args_info->output_orig = gengetopt_strdup (optarg);
          break;

        case 's':	/* source language (use --lang-list to get the complete list).  If not specified, the source language will be guessed from the file extension..  */
          if (local_args_info.src_lang_given)
            {
              fprintf (stderr, "%s: `--src-lang' (`-s') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->src_lang_given && ! override)
            continue;
          local_args_info.src_lang_given = 1;
          args_info->src_lang_given = 1;
          if (args_info->src_lang_arg)
            free (args_info->src_lang_arg); /* free previous string */
          args_info->src_lang_arg = gengetopt_strdup (optarg);
          if (args_info->src_lang_orig)
            free (args_info->src_lang_orig); /* free previous string */
          args_info->src_lang_orig = gengetopt_strdup (optarg);
          break;

        case 'f':	/* output format (use --outlang-list to get the complete list).  */
          if (local_args_info.out_format_given)
            {
              fprintf (stderr, "%s: `--out-format' (`-f') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->out_format_given && ! override)
            continue;
          local_args_info.out_format_given = 1;
          args_info->out_format_given = 1;
          if (args_info->out_format_arg)
            free (args_info->out_format_arg); /* free previous string */
          args_info->out_format_arg = gengetopt_strdup (optarg);
          if (args_info->out_format_orig)
            free (args_info->out_format_orig); /* free previous string */
          args_info->out_format_orig = gengetopt_strdup (optarg);
          break;

        case 'v':	/* verbose mode on.  */
          if (local_args_info.verbose_given)
            {
              fprintf (stderr, "%s: `--verbose' (`-v') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->verbose_given && ! override)
            continue;
          local_args_info.verbose_given = 1;
          args_info->verbose_given = 1;
          break;

        case 'd':	/* create an output file that can be used as a stand alone document (e.g., not to be included in another one).  */
          if (local_args_info.doc_given)
            {
              fprintf (stderr, "%s: `--doc' (`-d') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->doc_given && ! override)
            continue;
          local_args_info.doc_given = 1;
          args_info->doc_given = 1;
          break;

        case 'c':	/* the external style sheet filename.  Implies --doc.  */
          if (local_args_info.css_given)
            {
              fprintf (stderr, "%s: `--css' (`-c') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->css_given && ! override)
            continue;
          local_args_info.css_given = 1;
          args_info->css_given = 1;
          if (args_info->css_arg)
            free (args_info->css_arg); /* free previous string */
          args_info->css_arg = gengetopt_strdup (optarg);
          if (args_info->css_orig)
            free (args_info->css_orig); /* free previous string */
          args_info->css_orig = gengetopt_strdup (optarg);
          break;

        case 'T':	/* give a title to the output document.  Implies --doc.  */
          if (local_args_info.title_given)
            {
              fprintf (stderr, "%s: `--title' (`-T') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->title_given && ! override)
            continue;
          local_args_info.title_given = 1;
          args_info->title_given = 1;
          if (args_info->title_arg)
            free (args_info->title_arg); /* free previous string */
          args_info->title_arg = gengetopt_strdup (optarg);
          if (args_info->title_orig)
            free (args_info->title_orig); /* free previous string */
          args_info->title_orig = gengetopt_strdup (optarg);
          break;

        case 't':	/* specify tab length..  */
          if (local_args_info.tab_given)
            {
              fprintf (stderr, "%s: `--tab' (`-t') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->tab_given && ! override)
            continue;
          local_args_info.tab_given = 1;
          args_info->tab_given = 1;
          args_info->tab_arg = strtol (optarg,&stop_char,0);
          if (args_info->tab_orig)
            free (args_info->tab_orig); /* free previous string */
          args_info->tab_orig = gengetopt_strdup (optarg);
          break;

        case 'H':	/* file to insert as header.  */
          if (local_args_info.header_given)
            {
              fprintf (stderr, "%s: `--header' (`-H') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->header_given && ! override)
            continue;
          local_args_info.header_given = 1;
          args_info->header_given = 1;
          if (args_info->header_arg)
            free (args_info->header_arg); /* free previous string */
          args_info->header_arg = gengetopt_strdup (optarg);
          if (args_info->header_orig)
            free (args_info->header_orig); /* free previous string */
          args_info->header_orig = gengetopt_strdup (optarg);
          break;

        case 'F':	/* file to insert as footer.  */
          if (local_args_info.footer_given)
            {
              fprintf (stderr, "%s: `--footer' (`-F') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->footer_given && ! override)
            continue;
          local_args_info.footer_given = 1;
          args_info->footer_given = 1;
          if (args_info->footer_arg)
            free (args_info->footer_arg); /* free previous string */
          args_info->footer_arg = gengetopt_strdup (optarg);
          if (args_info->footer_orig)
            free (args_info->footer_orig); /* free previous string */
          args_info->footer_orig = gengetopt_strdup (optarg);
          break;

        case 'n':	/* number all output lines.  */
          if (local_args_info.line_number_given)
            {
              fprintf (stderr, "%s: `--line-number' (`-n') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->line_number_given && ! override)
            continue;
          local_args_info.line_number_given = 1;
          args_info->line_number_given = 1;
          break;


        case 0:	/* Long option with no short option */
          /* list all the supported language and associated language definition file.  */
          if (strcmp (long_options[option_index].name, "lang-list") == 0)
          {
            if (local_args_info.lang_list_given)
              {
                fprintf (stderr, "%s: `--lang-list' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->lang_list_given && ! override)
              continue;
            local_args_info.lang_list_given = 1;
            args_info->lang_list_given = 1;
            break;
          }
          /* list all the supported output language and associated language definition file.  */
          else if (strcmp (long_options[option_index].name, "outlang-list") == 0)
          {
            if (local_args_info.outlang_list_given)
              {
                fprintf (stderr, "%s: `--outlang-list' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->outlang_list_given && ! override)
              continue;
            local_args_info.outlang_list_given = 1;
            args_info->outlang_list_given = 1;
            break;
          }
          /* cancel the --doc option even if it is implied (e.g., when css is given).  */
          else if (strcmp (long_options[option_index].name, "no-doc") == 0)
          {
            if (local_args_info.no_doc_given)
              {
                fprintf (stderr, "%s: `--no-doc' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->no_doc_given && ! override)
              continue;
            local_args_info.no_doc_given = 1;
            args_info->no_doc_given = 1;
            break;
          }
          /* specify the file containing format options.  */
          else if (strcmp (long_options[option_index].name, "style-file") == 0)
          {
            if (local_args_info.style_file_given)
              {
                fprintf (stderr, "%s: `--style-file' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->style_file_given && ! override)
              continue;
            local_args_info.style_file_given = 1;
            args_info->style_file_given = 1;
            if (args_info->style_file_arg)
              free (args_info->style_file_arg); /* free previous string */
            args_info->style_file_arg = gengetopt_strdup (optarg);
            if (args_info->style_file_orig)
              free (args_info->style_file_orig); /* free previous string */
            args_info->style_file_orig = gengetopt_strdup (optarg);
          }
          /* output language definition file.  */
          else if (strcmp (long_options[option_index].name, "outlang-def") == 0)
          {
            if (local_args_info.outlang_def_given)
              {
                fprintf (stderr, "%s: `--outlang-def' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->outlang_def_given && ! override)
              continue;
            local_args_info.outlang_def_given = 1;
            args_info->outlang_def_given = 1;
            if (args_info->outlang_def_arg)
              free (args_info->outlang_def_arg); /* free previous string */
            args_info->outlang_def_arg = gengetopt_strdup (optarg);
            if (args_info->outlang_def_orig)
              free (args_info->outlang_def_orig); /* free previous string */
            args_info->outlang_def_orig = gengetopt_strdup (optarg);
          }
          /* output language map file.  */
          else if (strcmp (long_options[option_index].name, "outlang-map") == 0)
          {
            if (local_args_info.outlang_map_given)
              {
                fprintf (stderr, "%s: `--outlang-map' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->outlang_map_given && ! override)
              continue;
            local_args_info.outlang_map_given = 1;
            args_info->outlang_map_given = 1;
            if (args_info->outlang_map_arg)
              free (args_info->outlang_map_arg); /* free previous string */
            args_info->outlang_map_arg = gengetopt_strdup (optarg);
            if (args_info->outlang_map_orig)
              free (args_info->outlang_map_orig); /* free previous string */
            args_info->outlang_map_orig = gengetopt_strdup (optarg);
          }
          /* directory where language definition files and language maps are searched for.  If not specified these files are searched for in the current directory and in the data dir installation directory.  */
          else if (strcmp (long_options[option_index].name, "data-dir") == 0)
          {
            if (local_args_info.data_dir_given)
              {
                fprintf (stderr, "%s: `--data-dir' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->data_dir_given && ! override)
              continue;
            local_args_info.data_dir_given = 1;
            args_info->data_dir_given = 1;
            if (args_info->data_dir_arg)
              free (args_info->data_dir_arg); /* free previous string */
            args_info->data_dir_arg = gengetopt_strdup (optarg);
            if (args_info->data_dir_orig)
              free (args_info->data_dir_orig); /* free previous string */
            args_info->data_dir_orig = gengetopt_strdup (optarg);
          }
          /* output directory.  */
          else if (strcmp (long_options[option_index].name, "output-dir") == 0)
          {
            if (local_args_info.output_dir_given)
              {
                fprintf (stderr, "%s: `--output-dir' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->output_dir_given && ! override)
              continue;
            local_args_info.output_dir_given = 1;
            args_info->output_dir_given = 1;
            if (args_info->output_dir_arg)
              free (args_info->output_dir_arg); /* free previous string */
            args_info->output_dir_arg = gengetopt_strdup (optarg);
            if (args_info->output_dir_orig)
              free (args_info->output_dir_orig); /* free previous string */
            args_info->output_dir_orig = gengetopt_strdup (optarg);
          }
          /* language definition file.  */
          else if (strcmp (long_options[option_index].name, "lang-def") == 0)
          {
            if (local_args_info.lang_def_given)
              {
                fprintf (stderr, "%s: `--lang-def' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->lang_def_given && ! override)
              continue;
            local_args_info.lang_def_given = 1;
            args_info->lang_def_given = 1;
            if (args_info->lang_def_arg)
              free (args_info->lang_def_arg); /* free previous string */
            args_info->lang_def_arg = gengetopt_strdup (optarg);
            if (args_info->lang_def_orig)
              free (args_info->lang_def_orig); /* free previous string */
            args_info->lang_def_orig = gengetopt_strdup (optarg);
          }
          /* language map file.  */
          else if (strcmp (long_options[option_index].name, "lang-map") == 0)
          {
            if (local_args_info.lang_map_given)
              {
                fprintf (stderr, "%s: `--lang-map' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->lang_map_given && ! override)
              continue;
            local_args_info.lang_map_given = 1;
            args_info->lang_map_given = 1;
            if (args_info->lang_map_arg)
              free (args_info->lang_map_arg); /* free previous string */
            args_info->lang_map_arg = gengetopt_strdup (optarg);
            if (args_info->lang_map_orig)
              free (args_info->lang_map_orig); /* free previous string */
            args_info->lang_map_orig = gengetopt_strdup (optarg);
          }
          /* number all output lines and generate an anchor, made of the specified prefix + the line number.  */
          else if (strcmp (long_options[option_index].name, "line-number-ref") == 0)
          {
            if (local_args_info.line_number_ref_given)
              {
                fprintf (stderr, "%s: `--line-number-ref' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->line_number_ref_given && ! override)
              continue;
            local_args_info.line_number_ref_given = 1;
            args_info->line_number_ref_given = 1;
            if (optarg)
              {
                if (args_info->line_number_ref_arg)
                  free (args_info->line_number_ref_arg); /* free previous string */
                args_info->line_number_ref_arg = gengetopt_strdup (optarg);
                if (args_info->line_number_ref_orig)
                  free (args_info->line_number_ref_orig); /* free previous string */
                args_info->line_number_ref_orig = gengetopt_strdup (optarg);
              }
          }
          /* generate references.  */
          else if (strcmp (long_options[option_index].name, "gen-references") == 0)
          {
            if (local_args_info.gen_references_given)
              {
                fprintf (stderr, "%s: `--gen-references' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if ((found = check_possible_values(optarg, cmdline_parser_gen_references_values)) != 1)
              {
                fprintf (stderr, "%s: %s argument, \"%s\", for option `--gen-references'%s\n", argv[0], found ? "ambiguous" : "invalid", optarg, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->gen_references_given && ! override)
              continue;
            local_args_info.gen_references_given = 1;
            args_info->gen_references_given = 1;
            if (args_info->gen_references_arg)
              free (args_info->gen_references_arg); /* free previous string */
            args_info->gen_references_arg = gengetopt_strdup (optarg);
            if (args_info->gen_references_orig)
              free (args_info->gen_references_orig); /* free previous string */
            args_info->gen_references_orig = gengetopt_strdup (optarg);
          }
          /* specify the file generated by ctags that will be used to generate references.  */
          else if (strcmp (long_options[option_index].name, "ctags-file") == 0)
          {
            if (local_args_info.ctags_file_given)
              {
                fprintf (stderr, "%s: `--ctags-file' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->ctags_file_given && ! override)
              continue;
            local_args_info.ctags_file_given = 1;
            args_info->ctags_file_given = 1;
            if (args_info->ctags_file_arg)
              free (args_info->ctags_file_arg); /* free previous string */
            args_info->ctags_file_arg = gengetopt_strdup (optarg);
            if (args_info->ctags_file_orig)
              free (args_info->ctags_file_orig); /* free previous string */
            args_info->ctags_file_orig = gengetopt_strdup (optarg);
          }
          /* how to run the ctags command.  If this option is not specified, ctags will be executed with the default value.  If it is specified with an empty string, ctags will not be executed at all.  */
          else if (strcmp (long_options[option_index].name, "ctags") == 0)
          {
            if (local_args_info.ctags_given)
              {
                fprintf (stderr, "%s: `--ctags' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->ctags_given && ! override)
              continue;
            local_args_info.ctags_given = 1;
            args_info->ctags_given = 1;
            if (args_info->ctags_arg)
              free (args_info->ctags_arg); /* free previous string */
            args_info->ctags_arg = gengetopt_strdup (optarg);
            if (args_info->ctags_orig)
              free (args_info->ctags_orig); /* free previous string */
            args_info->ctags_orig = gengetopt_strdup (optarg);
          }
          /* put source-highlight version in the generated file.  */
          else if (strcmp (long_options[option_index].name, "gen-version") == 0)
          {
            if (local_args_info.gen_version_given)
              {
                fprintf (stderr, "%s: `--gen-version' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->gen_version_given && ! override)
              continue;
            local_args_info.gen_version_given = 1;
            args_info->gen_version_given = 1;
            args_info->gen_version_flag = !(args_info->gen_version_flag);
          }
          /* only check the correctness of a language definition file.  */
          else if (strcmp (long_options[option_index].name, "check-lang") == 0)
          {
            if (local_args_info.check_lang_given)
              {
                fprintf (stderr, "%s: `--check-lang' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->check_lang_given && ! override)
              continue;
            local_args_info.check_lang_given = 1;
            args_info->check_lang_given = 1;
            if (args_info->check_lang_arg)
              free (args_info->check_lang_arg); /* free previous string */
            args_info->check_lang_arg = gengetopt_strdup (optarg);
            if (args_info->check_lang_orig)
              free (args_info->check_lang_orig); /* free previous string */
            args_info->check_lang_orig = gengetopt_strdup (optarg);
          }
          /* only check the correctness of an output language definition file.  */
          else if (strcmp (long_options[option_index].name, "check-outlang") == 0)
          {
            if (local_args_info.check_outlang_given)
              {
                fprintf (stderr, "%s: `--check-outlang' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->check_outlang_given && ! override)
              continue;
            local_args_info.check_outlang_given = 1;
            args_info->check_outlang_given = 1;
            if (args_info->check_outlang_arg)
              free (args_info->check_outlang_arg); /* free previous string */
            args_info->check_outlang_arg = gengetopt_strdup (optarg);
            if (args_info->check_outlang_orig)
              free (args_info->check_outlang_orig); /* free previous string */
            args_info->check_outlang_orig = gengetopt_strdup (optarg);
          }
          /* if no language definition is found for the input, it is simply copied to the output.  */
          else if (strcmp (long_options[option_index].name, "failsafe") == 0)
          {
            if (local_args_info.failsafe_given)
              {
                fprintf (stderr, "%s: `--failsafe' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->failsafe_given && ! override)
              continue;
            local_args_info.failsafe_given = 1;
            args_info->failsafe_given = 1;
            break;
          }
          /* debug a language definition.  */
          else if (strcmp (long_options[option_index].name, "debug-langdef") == 0)
          {
            if (local_args_info.debug_langdef_given)
              {
                fprintf (stderr, "%s: `--debug-langdef' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->debug_langdef_given && ! override)
              continue;
            local_args_info.debug_langdef_given = 1;
            args_info->debug_langdef_given = 1;
            break;
          }
          /* show the regular expression automaton corresponding to a language definition file.  */
          else if (strcmp (long_options[option_index].name, "show-regex") == 0)
          {
            if (local_args_info.show_regex_given)
              {
                fprintf (stderr, "%s: `--show-regex' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->show_regex_given && ! override)
              continue;
            local_args_info.show_regex_given = 1;
            args_info->show_regex_given = 1;
            if (args_info->show_regex_arg)
              free (args_info->show_regex_arg); /* free previous string */
            args_info->show_regex_arg = gengetopt_strdup (optarg);
            if (args_info->show_regex_orig)
              free (args_info->show_regex_orig); /* free previous string */
            args_info->show_regex_orig = gengetopt_strdup (optarg);
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;

      args_info->inputs_num = argc - optind ;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;
    }

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
